package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.service.PullOrderService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 每半天执行一次订单拉取 避免丢失订单
 *
 * @author Gonzo
 * @date 2020-05-03 14:47
 * @since 2.0.0
 */
@Component
@Slf4j
@AllArgsConstructor
public class PullOrderByDayTask extends AbstractCronTask<String> {

    private final PullOrderService pullOrderFacadeService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    public ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());
        try {
            pullOrderFacadeService.pullOrderByDay();
            log.info("执行任务: {} 结束", taskName());
        } catch (Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
        }

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "每半天拉取订单信息_"+ tbkOpenOrderProperties.getSite();
    }

    @Override
    public String cron() {

        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getOrderRefundCron());
        }

        return orderTimerConfigProperties.getPullOrderByDayCron();
    }
}
