/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.thunlp.thulac.cb.CBTaggingDecoder;
import org.thunlp.thulac.data.POCGraph;
import org.thunlp.thulac.data.TaggedWord;
import org.thunlp.thulac.io.IInputProvider;
import org.thunlp.thulac.io.IOutputHandler;
import org.thunlp.thulac.io.StringOutputHandler;
import org.thunlp.thulac.postprocess.DictionaryPass;
import org.thunlp.thulac.postprocess.DoubleWordPass;
import org.thunlp.thulac.postprocess.FilterPass;
import org.thunlp.thulac.postprocess.IPostprocessPass;
import org.thunlp.thulac.postprocess.NegWordPass;
import org.thunlp.thulac.postprocess.SpecialPass;
import org.thunlp.thulac.postprocess.TimeWordPass;
import org.thunlp.thulac.preprocess.ConvertT2SPass;
import org.thunlp.thulac.preprocess.IPreprocessPass;
import org.thunlp.thulac.preprocess.PreprocessPass;
import org.thunlp.thulac.util.IOUtils;

public class Thulac {
    private List<IPostprocessPass> post = null;
    private List<IPreprocessPass> pre = null;
    private CBTaggingDecoder taggingDecoder = null;

    public String split(String modelDir, String input, boolean segOnly) throws IOException {
        StringOutputHandler outputProvider = IOUtils.outputToString();
        IInputProvider inputProvider = IOUtils.inputFromString(input);
        this.split(modelDir, inputProvider, outputProvider, segOnly);
        return outputProvider.getString();
    }

    public void split(String modelDir, String inputFile, String outputFile, boolean segOnly) throws IOException {
        if (inputFile == null || outputFile == null) {
            return;
        }
        IInputProvider input = IOUtils.inputFromFile(inputFile);
        IOutputHandler output = IOUtils.outputToFile(outputFile);
        this.split(modelDir, input, output, segOnly);
    }

    public void split(String modelDir, File input, File output, boolean segOnly) throws IOException {
        if (input == null) {
            throw new FileNotFoundException("input == null!");
        }
        if (output == null) {
            throw new FileNotFoundException("output == null!");
        }
        IInputProvider inputProvider = IOUtils.inputFromFile(input);
        IOutputHandler outputHandler = IOUtils.outputToFile(output);
        this.split(modelDir, inputProvider, outputHandler, segOnly);
    }

    public void split(String modelDir, IInputProvider input, IOutputHandler output, boolean segOnly) throws IOException {
        this.split(modelDir, '_', null, false, segOnly, false, input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(String modelDir, char separator, String userDict, boolean useT2S, boolean segOnly, boolean useFilter, IInputProvider input, IOutputHandler output) throws IOException {
        try {
            input.onProgramStart();
            output.onProgramStart();
            if (this.taggingDecoder == null) {
                this.taggingDecoder = new CBTaggingDecoder();
                this.taggingDecoder.threshold = segOnly ? 0 : 10000;
                String prefix = modelDir + (segOnly ? "cws_" : "model_c_");
                this.taggingDecoder.loadFiles(prefix + "model.bin", prefix + "dat.bin", prefix + "label.txt");
                this.taggingDecoder.setLabelTrans();
            }
            if (this.pre == null) {
                this.pre = new ArrayList<IPreprocessPass>();
                this.pre.add(new PreprocessPass());
                if (useT2S) {
                    this.pre.add(new ConvertT2SPass(modelDir + "t2s.dat"));
                }
            }
            if (this.post == null) {
                this.post = new ArrayList<IPostprocessPass>();
                this.post.add(new DictionaryPass(modelDir + "ns.dat", "ns", false));
                this.post.add(new DictionaryPass(modelDir + "idiom.dat", "i", false));
                this.post.add(new DictionaryPass(modelDir + "singlepun.dat", "w", false));
                this.post.add(new TimeWordPass());
                this.post.add(new DoubleWordPass());
                this.post.add(new SpecialPass());
                this.post.add(new NegWordPass(modelDir + "neg.dat"));
                if (userDict != null) {
                    this.post.add(new DictionaryPass(userDict, "uw", true));
                }
                if (useFilter) {
                    this.post.add(new FilterPass(modelDir + "xu.dat", modelDir + "time.dat"));
                }
            }
            Vector<TaggedWord> words = new Vector<TaggedWord>();
            POCGraph graph = new POCGraph();
            List<String> lineSegments = input.provideInput();
            while (lineSegments != null) {
                output.handleLineStart();
                for (String raw : lineSegments) {
                    for (IPreprocessPass iPreprocessPass : this.pre) {
                        raw = iPreprocessPass.process(raw, graph);
                    }
                    this.taggingDecoder.segment(raw, graph, words);
                    for (IPostprocessPass iPostprocessPass : this.post) {
                        iPostprocessPass.process(words);
                    }
                    output.handleLineSegment(words, segOnly, separator);
                }
                output.handleLineEnd();
                lineSegments = input.provideInput();
            }
        }
        finally {
            input.onProgramEnd();
            output.onProgramEnd();
        }
    }
}

