/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.postprocess;

import java.io.IOException;
import java.util.List;
import org.thunlp.thulac.data.Dat;
import org.thunlp.thulac.data.DatMaker;
import org.thunlp.thulac.data.TaggedWord;
import org.thunlp.thulac.postprocess.IPostprocessPass;

public class DictionaryPass
implements IPostprocessPass {
    private Dat dictionary;
    private String tag;

    public DictionaryPass(String dictFile, String tag, boolean isTxt) throws IOException {
        this.tag = tag;
        this.dictionary = isTxt ? DatMaker.readFromTxtFile(dictFile) : new Dat(dictFile);
    }

    @Override
    public void process(List<TaggedWord> sentence) {
        if (this.dictionary == null || sentence.isEmpty()) {
            return;
        }
        int size = sentence.size();
        for (int i = 0; i < size; ++i) {
            String current;
            int j;
            StringBuilder sb = new StringBuilder();
            String longest = null;
            int longestIndex = -1;
            for (j = i; j < size && this.dictionary.containsPrefix(current = sb.append(sentence.get((int)j).word).toString()); ++j) {
                if (!this.dictionary.contains(current)) continue;
                longest = current;
                longestIndex = j;
            }
            if (longest == null) continue;
            sentence.set(i, new TaggedWord(longest, this.tag));
            for (j = longestIndex; j > i; --j) {
                sentence.remove(j);
            }
            size = sentence.size();
        }
    }
}

