/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.postprocess;

import java.util.List;
import org.thunlp.thulac.data.TaggedWord;
import org.thunlp.thulac.postprocess.IPostprocessPass;
import org.thunlp.thulac.util.CodePointUtils;
import org.thunlp.thulac.util.StringUtils;

public class DoubleWordPass
implements IPostprocessPass {
    @Override
    public void process(List<TaggedWord> sentence) {
        if (sentence.size() <= 1) {
            return;
        }
        TaggedWord last = sentence.get(sentence.size() - 1);
        for (int i = sentence.size() - 2; i >= 0; --i) {
            TaggedWord tagged = sentence.get(i);
            if (this.canFormDoubleWord(tagged.word, last.word)) {
                tagged.word = tagged.word + last.word;
                sentence.remove(i + 1);
            }
            last = tagged;
        }
    }

    private boolean canFormDoubleWord(String first, String second) {
        int secondCP;
        if (StringUtils.codePointCount(first) != 1 || StringUtils.codePointCount(second) != 1) {
            return false;
        }
        int firstCP = first.codePointAt(0);
        return firstCP == (secondCP = second.codePointAt(0)) && CodePointUtils.SPECIAL_CHARS.indexOf(firstCP) == -1;
    }
}

