/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.postprocess;

import java.util.List;
import org.thunlp.thulac.data.TaggedWord;
import org.thunlp.thulac.postprocess.IPostprocessPass;
import org.thunlp.thulac.util.CodePointUtils;
import org.thunlp.thulac.util.StringUtils;

public class TimeWordPass
implements IPostprocessPass {
    private static final String TIME_UNITS = CodePointUtils.generate(Character.valueOf('\u5e74'), Character.valueOf('\u6708'), Character.valueOf('\u65e5'), Character.valueOf('\u53f7'), Character.valueOf('\u65f6'), Character.valueOf('\u70b9'), Character.valueOf('\u5206'), Character.valueOf('\u79d2'));

    private boolean isNumber(String word) {
        for (int codePoint : StringUtils.toCodePoints(word)) {
            if (CodePointUtils.DIGITS.indexOf(codePoint) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean isTimeUnit(String word) {
        return StringUtils.codePointCount(word) == 1 && TIME_UNITS.indexOf(word.codePointAt(0)) != -1;
    }

    @Override
    public void process(List<TaggedWord> sentence) {
        boolean isTimeWord = false;
        for (int i = sentence.size() - 1; i >= 0; --i) {
            TaggedWord tagged = sentence.get(i);
            if (this.isTimeUnit(tagged.word)) {
                isTimeWord = true;
                continue;
            }
            if (isTimeWord && this.isNumber(tagged.word)) {
                tagged.word = tagged.word + sentence.remove((int)(i + 1)).word;
                tagged.tag = "t";
                continue;
            }
            isTimeWord = false;
        }
    }
}

