/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.util;

import java.util.ArrayList;
import org.thunlp.thulac.util.StringUtils;

public class CodePointUtils {
    public static final String DIGITS = CodePointUtils.generate(CodePointUtils.range(48, 57), CodePointUtils.range(65296, 65305));
    public static final String CHINESE_DIGITS = CodePointUtils.generate(Character.valueOf('\u3007'), Character.valueOf('\u4e00'), Character.valueOf('\u4e8c'), Character.valueOf('\u4e09'), Character.valueOf('\u56db'), Character.valueOf('\u4e94'), Character.valueOf('\u516d'), Character.valueOf('\u4e03'), Character.valueOf('\u516b'), Character.valueOf('\u4e5d'));
    public static final String SPECIAL_CHARS = CodePointUtils.generate(Character.valueOf('\uff0c'), Character.valueOf('\u3002'), Character.valueOf('\uff1f'), Character.valueOf('\uff01'), Character.valueOf('\uff1a'), Character.valueOf('\uff1b'), Character.valueOf('\u3010'), Character.valueOf('\u3011'), Character.valueOf('\u3001'), Character.valueOf('\u300a'), Character.valueOf('\u300b'), Character.valueOf('\uff08'), Character.valueOf('\uff09'), Character.valueOf('\u2018'), Character.valueOf('\u2019'), Character.valueOf('\u201c'), Character.valueOf('\u201d'), Character.valueOf('\u00b7'), Character.valueOf('\u2026'), Character.valueOf('\u2014'), Character.valueOf('\uffe5'), Character.valueOf('\u25e4'), Character.valueOf('\u2605'), Character.valueOf('\u2606'), CodePointUtils.range(33, 95), CodePointUtils.range(97, 126));
    public static final String WHITESPACE_CHARS = CodePointUtils.generate(Character.valueOf(' '), Character.valueOf('\u3000'));

    public static String generate(Object ... params) {
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        for (Object param : params) {
            if (param instanceof Integer) {
                codePoints.add((Integer)param);
                continue;
            }
            if (param instanceof int[]) {
                for (int codePoint : (int[])param) {
                    codePoints.add(codePoint);
                }
                continue;
            }
            if (param instanceof String) {
                for (int codePoint : StringUtils.toCodePoints((String)param)) {
                    codePoints.add(codePoint);
                }
                continue;
            }
            if (!(param instanceof Character)) continue;
            codePoints.add(Integer.valueOf(((Character)param).charValue()));
        }
        int[] cps = new int[codePoints.size()];
        int size = codePoints.size();
        for (int i = 0; i < size; ++i) {
            cps[i] = (Integer)codePoints.get(i);
        }
        return StringUtils.toString(cps);
    }

    public static int[] range(int start, int end) {
        if (end < start) {
            return null;
        }
        int[] range = new int[end - start + 1];
        for (int i = start; i <= end; ++i) {
            range[i - start] = i;
        }
        return range;
    }
}

