/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thunlp.thulac.io.IInputProvider;
import org.thunlp.thulac.io.IOutputHandler;
import org.thunlp.thulac.io.ReaderInputProvider;
import org.thunlp.thulac.io.StringInputProvider;
import org.thunlp.thulac.io.StringOutputHandler;
import org.thunlp.thulac.io.WriterOutputHandler;

public class IOUtils {
    private static final int MAX_LENGTH = 20000;
    private static final Pattern SPLIT_PATTERN = Pattern.compile(".*([\u3002\uff1f\uff01\uff1b;!?]|$)");

    public static IInputProvider inputFromConsole() {
        return IOUtils.inputFromInputStream(System.in);
    }

    public static IInputProvider inputFromInputStream(InputStream in) {
        return IOUtils.inputFromInputStream(in, (Charset)null);
    }

    public static IInputProvider inputFromInputStream(InputStream in, String charsetName) throws UnsupportedCharsetException {
        return IOUtils.inputFromInputStream(in, IOUtils.forName(charsetName));
    }

    public static IInputProvider inputFromInputStream(InputStream in, Charset charset) {
        return new ReaderInputProvider(new BufferedReader(new InputStreamReader(in, IOUtils.getOrDefault(charset))));
    }

    public static IInputProvider inputFromFile(String filename) throws IOException {
        return IOUtils.inputFromFile(filename, (Charset)null);
    }

    public static IInputProvider inputFromFile(File file) throws IOException {
        return IOUtils.inputFromFile(file, (Charset)null);
    }

    public static IInputProvider inputFromFile(String filename, String charsetName) throws IOException, UnsupportedCharsetException {
        return IOUtils.inputFromFile(filename, IOUtils.forName(charsetName));
    }

    public static IInputProvider inputFromFile(String filename, Charset charset) throws IOException {
        if (filename == null) {
            return null;
        }
        return IOUtils.inputFromFile(new File(filename), charset);
    }

    public static IInputProvider inputFromFile(File file, String charsetName) throws IOException, UnsupportedCharsetException {
        return IOUtils.inputFromFile(file, IOUtils.forName(charsetName));
    }

    public static IInputProvider inputFromFile(File file, Charset charset) throws IOException {
        if (file == null) {
            return null;
        }
        return new ReaderInputProvider(Files.newBufferedReader(Paths.get(file.toURI()), IOUtils.getOrDefault(charset)));
    }

    public static IInputProvider inputFromString(String input) {
        if (input == null) {
            return null;
        }
        return new StringInputProvider(input);
    }

    public static IOutputHandler outputToConsole() {
        return new WriterOutputHandler(new BufferedWriter(new OutputStreamWriter(System.out)));
    }

    public static IOutputHandler outputToOutputStream(OutputStream out) {
        return IOUtils.outputToOutputStream(out, (Charset)null);
    }

    public static IOutputHandler outputToOutputStream(OutputStream out, String charsetName) throws UnsupportedCharsetException {
        return IOUtils.outputToOutputStream(out, IOUtils.forName(charsetName));
    }

    public static IOutputHandler outputToOutputStream(OutputStream out, Charset charset) {
        return new WriterOutputHandler(new BufferedWriter(new OutputStreamWriter(out, IOUtils.getOrDefault(charset))));
    }

    public static IOutputHandler outputToFile(String filename) throws IOException {
        return IOUtils.outputToFile(filename, (Charset)null);
    }

    public static IOutputHandler outputToFile(File file) throws IOException {
        return IOUtils.outputToFile(file, (Charset)null);
    }

    public static IOutputHandler outputToFile(String filename, String charsetName) throws IOException, UnsupportedCharsetException {
        return IOUtils.outputToFile(filename, IOUtils.forName(charsetName));
    }

    public static IOutputHandler outputToFile(String filename, Charset charset) throws IOException {
        if (filename == null) {
            return null;
        }
        return IOUtils.outputToFile(new File(filename), charset);
    }

    public static IOutputHandler outputToFile(File file, String charsetName) throws IOException, UnsupportedCharsetException {
        return IOUtils.outputToFile(file, IOUtils.forName(charsetName));
    }

    public static IOutputHandler outputToFile(File file, Charset charset) throws IOException {
        if (file == null) {
            return null;
        }
        return new WriterOutputHandler(Files.newBufferedWriter(Paths.get(file.toURI()), IOUtils.getOrDefault(charset), new OpenOption[0]));
    }

    public static StringOutputHandler outputToString() {
        return new StringOutputHandler();
    }

    public static List<String> getLineSegments(String line) {
        ArrayList<String> lineSegments = new ArrayList<String>();
        if (line.length() < 20000) {
            lineSegments.add(line);
        } else {
            Matcher matcher = SPLIT_PATTERN.matcher(line);
            while (matcher.find()) {
                lineSegments.add(matcher.group());
            }
        }
        return lineSegments;
    }

    private static Charset forName(String charset) throws UnsupportedCharsetException {
        if (charset == null) {
            return null;
        }
        return Charset.forName(charset);
    }

    private static Charset getOrDefault(Charset charset) {
        return charset == null ? StandardCharsets.UTF_8 : charset;
    }
}

