/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.ueditor;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.util.ResourceUtils;

public final class ConfigManager {
    private static final String configFileName = "config.json";
    private static final String SCRAWL_FILE_NAME = "scrawl";
    private static final String REMOTE_FILE_NAME = "remote";
    private final String rootPath;
    private final String originalPath;
    private final String contextPath;
    private String parentPath = null;
    private JSONObject jsonConfig = null;

    private ConfigManager(String rootPath, String contextPath, String uri) throws FileNotFoundException, IOException {
        this.rootPath = rootPath = rootPath.replace("\\", "/");
        this.contextPath = contextPath;
        this.originalPath = contextPath.length() > 0 ? this.rootPath + uri.substring(contextPath.length()) : this.rootPath + uri;
        this.initEnv();
    }

    public static ConfigManager getInstance(String rootPath, String contextPath, String uri) {
        try {
            return new ConfigManager(rootPath, contextPath, uri);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean valid() {
        return this.jsonConfig != null;
    }

    public JSONObject getAllConfig() {
        return this.jsonConfig;
    }

    public Map<String, Object> getConfig(int type) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String savePath = null;
        switch (type) {
            case 4: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.jsonConfig.getLong("fileMaxSize"));
                conf.put("allowFiles", this.getArray("fileAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("fileFieldName"));
                savePath = this.jsonConfig.getString("filePathFormat");
                break;
            }
            case 1: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.jsonConfig.getLong("imageMaxSize"));
                conf.put("allowFiles", this.getArray("imageAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("imageFieldName"));
                savePath = this.jsonConfig.getString("imagePathFormat");
                break;
            }
            case 3: {
                conf.put("maxSize", this.jsonConfig.getLong("videoMaxSize"));
                conf.put("allowFiles", this.getArray("videoAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("videoFieldName"));
                savePath = this.jsonConfig.getString("videoPathFormat");
                break;
            }
            case 2: {
                conf.put("filename", SCRAWL_FILE_NAME);
                conf.put("maxSize", this.jsonConfig.getLong("scrawlMaxSize"));
                conf.put("fieldName", this.jsonConfig.getString("scrawlFieldName"));
                conf.put("isBase64", "true");
                savePath = this.jsonConfig.getString("scrawlPathFormat");
                break;
            }
            case 5: {
                conf.put("filename", REMOTE_FILE_NAME);
                conf.put("filter", this.getArray("catcherLocalDomain"));
                conf.put("maxSize", this.jsonConfig.getLong("catcherMaxSize"));
                conf.put("allowFiles", this.getArray("catcherAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("catcherFieldName") + "[]");
                savePath = this.jsonConfig.getString("catcherPathFormat");
                break;
            }
            case 7: {
                conf.put("allowFiles", this.getArray("imageManagerAllowFiles"));
                conf.put("dir", this.jsonConfig.getString("imageManagerListPath"));
                conf.put("count", this.jsonConfig.getInt("imageManagerListSize"));
                break;
            }
            case 6: {
                conf.put("allowFiles", this.getArray("fileManagerAllowFiles"));
                conf.put("dir", this.jsonConfig.getString("fileManagerListPath"));
                conf.put("count", this.jsonConfig.getInt("fileManagerListSize"));
            }
        }
        conf.put("savePath", savePath);
        conf.put("rootPath", this.rootPath);
        return conf;
    }

    private void initEnv() throws FileNotFoundException, IOException {
        String configContent = this.readFile();
        try {
            JSONObject jsonConfig;
            this.jsonConfig = jsonConfig = new JSONObject(configContent);
        }
        catch (Exception e) {
            this.jsonConfig = null;
        }
    }

    private String getConfigPath() {
        try {
            return ResourceUtils.getURL((String)"classpath:config.json").getPath();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] getArray(String key) {
        JSONArray jsonArray = this.jsonConfig.getJSONArray(key);
        String[] result = new String[jsonArray.length()];
        int len = jsonArray.length();
        for (int i = 0; i < len; ++i) {
            result[i] = jsonArray.getString(i);
        }
        return result;
    }

    private String readFile() throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(configFileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        while ((line = br.readLine()) != null) {
            builder.append(line);
        }
        return this.filter(builder.toString());
    }

    private String readFile(String path) throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
            BufferedReader bfReader = new BufferedReader(reader);
            String tmpContent = null;
            while ((tmpContent = bfReader.readLine()) != null) {
                builder.append(tmpContent);
            }
            bfReader.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.filter(builder.toString());
    }

    private String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }
}

