/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid.strategy;

import cn.hutool.core.date.SystemClock;
import com.bxm.newidea.component.annotations.StrategyBean;
import com.bxm.newidea.component.strategy.IReturnedStrategy;
import com.bxm.newidea.component.tools.IPUtil;
import com.bxm.newidea.component.uuid.config.ComponentUUIDConfigurationProperties;
import com.bxm.newidea.component.uuid.config.SequenceConfigHolder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

@StrategyBean(group="COMPONENT_UUID_ACQUIRE_CONFIG_GROUP")
@ConditionalOnClass(name={"org.apache.curator.framework.CuratorFramework"})
public class ZookeeperAcquireConfigStrategy
implements IReturnedStrategy<SequenceConfigHolder, Void> {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperAcquireConfigStrategy.class);
    private final ComponentUUIDConfigurationProperties properties;
    private CuratorFramework curatorFramework;
    private String identification;

    public ZookeeperAcquireConfigStrategy(ComponentUUIDConfigurationProperties properties) {
        this.properties = properties;
    }

    public SequenceConfigHolder execute(Void param) {
        SequenceConfigHolder holder;
        this.initCuratorFramework();
        long workerId = 0L;
        try {
            String foreverPath = this.getForeverPath();
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(foreverPath);
            if (stat == null) {
                this.createNode();
            } else {
                workerId = this.getWorkerId();
            }
            holder = SequenceConfigHolder.builder().workerId(workerId).build();
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u6216\u8bbf\u95eezookeeper\u51fa\u9519\uff0c\u91c7\u7528\u5907\u7528\u65b9\u6848\u3002" + e.getMessage(), (Throwable)e);
            holder = SequenceConfigHolder.builder().workerId(0L).build();
        }
        log.info("\u901a\u8fc7zookeeper\u83b7\u53d6workerId\uff1a[{}],path:[{}]", (Object)workerId, (Object)(this.getNodePath() + workerId));
        return holder;
    }

    private long getWorkerId() throws Exception {
        List keys = (List)this.curatorFramework.getChildren().forPath(this.getForeverPath());
        String identification = this.getIdentification();
        for (String nodeKey : keys) {
            String[] split = StringUtils.split((String)nodeKey, (String)"-");
            if (!identification.equals(split[0])) continue;
            this.updateNodeData(nodeKey);
            return Long.valueOf(split[1]);
        }
        String nodeKey = this.createNode();
        String[] split = StringUtils.split((String)nodeKey, (String)"-");
        return Long.valueOf(split[1]);
    }

    private void initCuratorFramework() {
        if (null == this.curatorFramework) {
            if (StringUtils.isBlank((CharSequence)this.properties.getZookeeperAddress())) {
                throw new IllegalArgumentException("component.uuid.zookeeperAddress\u672a\u914d\u7f6e");
            }
            RetryUntilElapsed retry = new RetryUntilElapsed(1000, 4);
            this.curatorFramework = CuratorFrameworkFactory.builder().retryPolicy((RetryPolicy)retry).connectString(this.properties.getZookeeperAddress()).connectionTimeoutMs(3000).sessionTimeoutMs(5000).build();
            this.curatorFramework.start();
        }
    }

    private String createNode() throws Exception {
        String nodePath = this.getNodePath();
        log.info("\u521b\u5efa\u5b58\u50a8uuid workerId\u7684nodePath\uff1a{}", (Object)nodePath);
        return (String)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(nodePath, this.buildData());
    }

    private void updateNodeData(String nodeName) throws Exception {
        String path = this.getForeverPath() + "/" + nodeName;
        this.curatorFramework.setData().forPath(path, this.buildData());
    }

    private String getNodePath() {
        return this.getForeverPath() + "/" + this.getIdentification() + "-";
    }

    private String getForeverPath() {
        return "/component/seq/" + this.properties.getPureLeafName();
    }

    private String getIdentification() {
        if (null == this.identification) {
            this.identification = IPUtil.getLocalRealIp() + ":" + this.properties.getLeafPort();
        }
        return this.identification;
    }

    private byte[] buildData() {
        return String.valueOf(SystemClock.now()).getBytes();
    }

    public String name() {
        return "zk";
    }
}

