package com.bxm.newidea.component.constraintvalidators;

import com.bxm.newidea.component.constraints.MobilePhoneNumber;
import com.bxm.newidea.component.tools.Validater;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 验证手机号码是否格式正确
 * @author liujia
 * @date 2020/04/22 10:31
 */
public class MobilePhoneNumberValidator implements ConstraintValidator<MobilePhoneNumber, String> {

    private MobilePhoneNumber mobilePhoneNumber;

    @Override
    public void initialize(MobilePhoneNumber constraintAnnotation) {
        this.mobilePhoneNumber = constraintAnnotation;
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (mobilePhoneNumber.strict()) {
            return Validater.checkPhoneWithStrict(value);
        }
        return Validater.checkPhone(value);
    }
}
