/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.mvc;

import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.mvc.ApiVersionRequestCondition;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiVersionRequestMapping
extends RequestMappingHandlerMapping {
    private static final Logger log = LoggerFactory.getLogger(ApiVersionRequestMapping.class);
    private static final String VERSION = "{version}";
    private Field valueCacheField;

    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        ApiVersion apiVersion = (ApiVersion)AnnotationUtils.findAnnotation(handlerType, ApiVersion.class);
        return this.create(apiVersion);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        ApiVersion apiVersion = (ApiVersion)AnnotationUtils.findAnnotation((Method)method, ApiVersion.class);
        return this.create(apiVersion);
    }

    private RequestCondition<ApiVersionRequestCondition> create(ApiVersion version) {
        return null == version ? null : new ApiVersionRequestCondition(version.value());
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = null;
        RequestMapping methodRequestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        RequestCondition<?> methodCondition = this.getCustomMethodCondition(method);
        if (Objects.nonNull(methodRequestMapping)) {
            info = this.createRequestMappingInfo(methodRequestMapping, methodCondition);
            RequestMapping classRequestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(handlerType, RequestMapping.class);
            if (Objects.nonNull(classRequestMapping)) {
                RequestMappingInfo typeInfo = this.createRequestMappingInfoByApiVersion(classRequestMapping, methodCondition);
                info = typeInfo.combine(info);
            }
        }
        return info;
    }

    private RequestMappingInfo createRequestMappingInfoByApiVersion(RequestMapping requestMapping, RequestCondition<?> customCondition) {
        if (Objects.nonNull(customCondition) && customCondition instanceof ApiVersionRequestCondition) {
            ApiVersionRequestCondition versionRequestCondition = (ApiVersionRequestCondition)customCondition;
            int v = versionRequestCondition.getApiVersion();
            try {
                requestMapping.value();
                String[] paths = requestMapping.path();
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(requestMapping);
                if (Objects.isNull(this.valueCacheField)) {
                    this.valueCacheField = ReflectionUtils.findField(invocationHandler.getClass(), (String)"valueCache");
                    if (Objects.nonNull(this.valueCacheField)) {
                        this.valueCacheField.setAccessible(true);
                    }
                }
                if (Objects.nonNull(this.valueCacheField)) {
                    Map map = (Map)this.valueCacheField.get(invocationHandler);
                    List<String> pathArray = Arrays.stream(paths).map(p -> {
                        if (p.contains(VERSION)) {
                            return p.replace(VERSION, StringUtils.join((Object[])new Serializable[]{"v", Integer.valueOf(v)}));
                        }
                        return p;
                    }).collect(Collectors.toList());
                    map.put("path", pathArray.toArray(paths));
                    map.put("value", pathArray.toArray(paths));
                }
            }
            catch (Exception e) {
                log.error("replace version failed", (Throwable)e);
            }
        }
        return super.createRequestMappingInfo(requestMapping, null);
    }
}

