/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidBuilder {
    private boolean direct;
    private Map<Object, Object> validMap = new HashMap<Object, Object>();
    private DirectFieldBindingResult bindingResult;
    private String field;
    private Object value;

    public ValidBuilder(boolean direct) {
        this.direct = direct;
        this.bindingResult = new DirectFieldBindingResult((Object)this, this.getClass().getSimpleName());
    }

    public ValidBuilder prop(String field, Object value) {
        this.field = field;
        this.value = value;
        return this;
    }

    public ValidBuilder notBlank() throws BindException {
        return this.notBlank(null);
    }

    public ValidBuilder notBlank(String message) throws BindException {
        if (null == this.value || StringUtils.isBlank((CharSequence)this.value.toString())) {
            this.addError(message, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        return this;
    }

    public ValidBuilder max(long size) throws BindException {
        return this.max(size, null);
    }

    public ValidBuilder max(long size, String message) throws BindException {
        if (null != this.value) {
            if (ReflectionUtils.isNumeric((Object)this.value)) {
                long numValue = NumberUtils.parseToLong((String)this.value.toString());
                if (numValue > size) {
                    this.addError(message, "\u53c2\u6570\u4e0d\u80fd\u5927\u4e8e{}", size);
                }
            } else if ((long)this.value.toString().length() > size) {
                this.addError(message, "\u53c2\u6570\u6700\u591a\u63a5\u53d7{}\u4e2a\u5b57\u7b26", size);
            }
        }
        return this;
    }

    public ValidBuilder min(long size) throws BindException {
        return this.min(size, null);
    }

    public ValidBuilder min(long size, String message) throws BindException {
        if (null != this.value) {
            if (ReflectionUtils.isNumeric((Object)this.value)) {
                long numValue = NumberUtils.parseToLong((String)this.value.toString());
                if (numValue < size) {
                    this.addError(message, "\u53c2\u6570\u4e0d\u80fd\u5c0f\u4e8e{}", size);
                }
            } else if ((long)this.value.toString().length() < size) {
                this.addError(message, "\u53c2\u6570\u6700\u5c11\u9700\u8981{}\u4e2a\u5b57\u7b26", size);
            }
        }
        return this;
    }

    private void addError(String message, String defaultMsg, Object ... replaces) throws BindException {
        if (StringUtils.isBlank((CharSequence)message)) {
            message = defaultMsg;
            if (null != replaces) {
                for (Object obj : replaces) {
                    message = StringUtils.replace((String)message, (String)"{}", (String)obj.toString());
                }
            }
        }
        this.bindingResult.addError((ObjectError)new FieldError(this.getClass().getSimpleName(), this.field, message));
        this.isDirect();
    }

    private void isDirect() throws BindException {
        if (this.direct) {
            this.valid();
        }
    }

    public void valid() throws BindException {
        if (this.bindingResult.hasErrors()) {
            throw new BindException((BindingResult)this.bindingResult);
        }
    }
}

