/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.vo;

import com.bxm.newidea.component.bo.Message;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.http.HttpStatus;

@ApiModel(description="\u81ea\u5b9a\u4e49\u7684JSON\u683c\u5f0f")
public class ResponseJson<T> {
    @ApiModelProperty(required=true, value="\u8bf7\u6c42\u54cd\u5e94\u7f16\u7801\uff0c\u72b6\u6001\u503c\u4e0eHttp Status\u4e00\u81f4\uff0c\u7528\u4e8e\u5224\u65ad\u8bf7\u6c42\u662f\u5426\u6210\u529f", example="200/400/401/403/404/500")
    private int code;
    @ApiModelProperty(value="\u54cd\u5e94\u72b6\u6001\u7801\u4e0d\u7b49\u4e8e200\u65f6\uff0c\u663e\u793a\u7528\u7684\u9519\u8bef\u6d88\u606f")
    private String errorMsg;
    @ApiModelProperty(value="\u6b63\u786e\u8bf7\u6c42\u7684\u60c5\u51b5\u4e0b\uff0c\u5bf9\u5e94\u7684\u9519\u8bef\u4e1a\u52a1\u7f16\u7801\uff0c\u5177\u4f53\u89e3\u91ca\u8be6\u89c1\u5bf9\u5e94\u7684API\u63cf\u8ff0")
    private String bizCode;
    @ApiModelProperty(value="\u8bf7\u6c42\u7684\u4e3b\u4f53\u6570\u636e\uff0c\u8be6\u89c1\u6a21\u578b\u89e3\u91ca\u548c\u63a5\u53e3\u6ce8\u91ca")
    private T result;

    private ResponseJson() {
        this.code = HttpStatus.OK.value();
    }

    private ResponseJson(HttpStatus code, String bizCode, String errorMsg, T result) {
        this.code = code.value();
        this.errorMsg = errorMsg;
        this.result = result;
        this.bizCode = bizCode;
    }

    public static ResponseJson build(Message message) {
        return new BodyBuilder(message.isSuccess() ? HttpStatus.OK : HttpStatus.BAD_REQUEST).errorMsg(message.getLastMessage()).build();
    }

    public static <T> ResponseJson<T> build() {
        return ResponseJson.ok().build();
    }

    public static <T> ResponseJson<T> ok(T result) {
        return ResponseJson.ok().body(result);
    }

    public static BodyBuilder status(HttpStatus status) {
        return ResponseJson.statusBody(status);
    }

    public static BodyBuilder ok() {
        return ResponseJson.statusBody(HttpStatus.OK);
    }

    public static BodyBuilder badReqeuset() {
        return ResponseJson.statusBody(HttpStatus.BAD_REQUEST);
    }

    public static BodyBuilder badReqeuset(String errorMsg) {
        return ResponseJson.badReqeuset().errorMsg(errorMsg);
    }

    public static BodyBuilder notFound() {
        return ResponseJson.statusBody(HttpStatus.BAD_REQUEST);
    }

    public static BodyBuilder notFound(String errorMsg) {
        return ResponseJson.notFound().errorMsg(errorMsg);
    }

    public static BodyBuilder serverError() {
        return ResponseJson.statusBody(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static BodyBuilder serverError(String errorMsg) {
        return ResponseJson.serverError().errorMsg(errorMsg);
    }

    public static BodyBuilder unauthorized() {
        return ResponseJson.statusBody(HttpStatus.UNAUTHORIZED);
    }

    public static BodyBuilder unauthorized(String errorMsg) {
        return ResponseJson.unauthorized().errorMsg(errorMsg);
    }

    private static BodyBuilder statusBody(HttpStatus status) {
        return new BodyBuilder(status);
    }

    public boolean success() {
        return this.code == HttpStatus.OK.value();
    }

    public int getCode() {
        return this.code;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public T getResult() {
        return this.result;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static class BodyBuilder {
        private HttpStatus status;
        private String errorMsg = "";
        private String bizCode = "";

        BodyBuilder(HttpStatus status) {
            this.status = status;
        }

        public BodyBuilder status(HttpStatus status) {
            this.status = status;
            return this;
        }

        public BodyBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public BodyBuilder bizCode(String bizCode) {
            this.bizCode = bizCode;
            return this;
        }

        public <T> ResponseJson<T> build() {
            return this.body(null);
        }

        public <T> ResponseJson<T> body(T body) {
            return new ResponseJson(this.status, this.bizCode, this.errorMsg, body);
        }
    }
}

