/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.config;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.ComponentWebConfigurationProperties;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ComponentWebConfigurationProperties.class, JacksonProperties.class})
public class ComponentWebMessageConverterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentWebMessageConverterAutoConfiguration.class);
    private ComponentWebConfigurationProperties componentWebConfigurationProperties;

    public ComponentWebMessageConverterAutoConfiguration(ComponentWebConfigurationProperties componentWebConfigurationProperties) {
        this.componentWebConfigurationProperties = componentWebConfigurationProperties;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter(ObjectMapper objectMapper) {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setObjectMapper(objectMapper);
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(new MediaType(MediaType.TEXT_PLAIN, Charset.forName("UTF-8")));
        supportedMediaTypes.add(new MediaType(MediaType.APPLICATION_JSON, Charset.forName("UTF-8")));
        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);
        if (this.componentWebConfigurationProperties.isJsonConvertLangType()) {
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            objectMapper.registerModule((Module)simpleModule);
            log.info("\u542f\u7528\u4e86json\u8f6c\u5316\u4e2d\u5c06lang\u7c7b\u578b\u8f6c\u5316\u4e3a\u5b57\u7b26\u4e32\u7684\u529f\u80fd");
        }
        if (this.componentWebConfigurationProperties.isUseUnifiedObjectMapper()) {
            JSON.registerObjectMapper((ObjectMapper)objectMapper);
        }
        return jsonConverter;
    }
}

