/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.config;

import com.bxm.newidea.component.config.ComponentWebConfigurationProperties;
import com.bxm.newidea.component.log.LogContextFilter;
import com.bxm.newidea.component.mvc.ApiVersionRequestMapping;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ComponentWebConfigurationProperties.class})
public class ComponentWebAutoConfiguration
implements WebMvcRegistrations {
    private ComponentWebConfigurationProperties properties;

    public ComponentWebAutoConfiguration(ComponentWebConfigurationProperties properties) {
        this.properties = properties;
    }

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new ApiVersionRequestMapping();
    }

    @Bean
    @ConditionalOnProperty(prefix="component.web", value={"enableLogFilter"}, matchIfMissing=true)
    public LogContextFilter logContextFilter() {
        return new LogContextFilter(this.properties);
    }

    @Bean
    @Primary
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(this.properties.isFastValid()).buildValidatorFactory();
        return validatorFactory.getValidator();
    }
}

