package com.bxm.newidea.component.mvc;

import com.bxm.newidea.component.annotations.ApiVersion;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.lang.reflect.Method;

/**
 * 根据版本号进行匹配表达
 * @author liujia
 */
public class ApiVersionRequestMapping extends RequestMappingHandlerMapping {
    @Override
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        ApiVersion apiVersion = AnnotationUtils.findAnnotation(handlerType, ApiVersion.class);
        return create(apiVersion);
    }

    @Override
    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        ApiVersion apiVersion = AnnotationUtils.findAnnotation(method, ApiVersion.class);
        return create(apiVersion);
    }

    private RequestCondition<ApiVersionRequestCondition> create(ApiVersion version) {
        return null == version ? null : new ApiVersionRequestCondition(version.value());
    }
}
