package com.bxm.newidea.component.wechat.extend;

import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;

/**
 * httpclient 连接管理器
 *
 * @author kakotor
 */
public class CustomApacheHttpClientBuilder implements ApacheHttpClientBuilder {

    private final CloseableHttpClient closeableHttpClient;

    public CustomApacheHttpClientBuilder(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = closeableHttpClient;
    }

    @Override
    public CloseableHttpClient build() {
        return this.closeableHttpClient;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyHost(String httpProxyHost) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPort(int httpProxyPort) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyUsername(String httpProxyUsername) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPassword(String httpProxyPassword) {
        return this;
    }

    @Override
    public ApacheHttpClientBuilder sslConnectionSocketFactory(SSLConnectionSocketFactory sslConnectionSocketFactory) {
        return this;
    }
}
