package com.bxm.newidea.component.wechat.service.impl;

import com.bxm.newidea.component.wechat.config.WechatMpAccount;
import com.bxm.newidea.component.wechat.config.WechatMpContext;
import com.bxm.newidea.component.wechat.param.WechatOnAuth2UrlParam;
import com.bxm.newidea.component.wechat.param.WxMpJsSignatureParam;
import com.bxm.newidea.component.wechat.service.WechatMpService;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;


@Service
@Slf4j
public class WechatMpServiceImpl implements WechatMpService {

    private final WechatMpContext context;

    @Autowired
    public WechatMpServiceImpl(WechatMpContext context) {
        this.context = context;
    }

    @Override
    public String acquireAuthUrl(WechatOnAuth2UrlParam param) {
        WxMpService wxMpService = context.obtain(param.getScene());

        if (wxMpService == null) {
            return null;
        }

        //对授权地址进行验证
        WechatMpAccount wechatMpAccount = context.obtainAccount(wxMpService);
        String[] authDomainUrls = wechatMpAccount.getAuthDomainUrls().toArray(new String[]{});

        if (!StringUtils.startsWithAny(param.getRedirectURI(), authDomainUrls)) {
            //暂时不做强制处理，仍然返回报错信息
            log.error("获取微信授权地址的回调地址与微信公众号配置的授权域名不匹配，场景值：[{}],微信公众号：[{} - {} ]，请求域名：[{}]，配置的安全域名:[{}]",
                    param.getScene(),
                    wechatMpAccount.getAlias(),
                    wechatMpAccount.getAppId(),
                    param.getRedirectURI(),
                    Arrays.toString(authDomainUrls));
        }

        String authUrl = String.format(WxMpService.CONNECT_OAUTH2_AUTHORIZE_URL,
                wxMpService.getWxMpConfigStorage().getAppId(),
                param.getRedirectURI(),
                param.getScope(),
                StringUtils.trimToEmpty(param.getState()));

        log.debug("场景[{}]对应的[{}]生成最终授权URL为：{}",
                param.getScene(),
                param.getRedirectURI(),
                authUrl);

        return authUrl;
    }

    @Override
    public WxJsapiSignature acquireJsSignature(WxMpJsSignatureParam param) {
        WxMpService wxMpService = context.obtain(param.getScene());

        if (wxMpService == null) {
            return null;
        }

        try {
            //js安全域名进行验证
            WechatMpAccount wechatMpAccount = context.obtainAccount(wxMpService);
            String[] jsDomainUrls = wechatMpAccount.getJsSignatureDomainUrls().toArray(new String[]{});

            if (!StringUtils.startsWithAny(param.getUrl(), jsDomainUrls)) {
                //暂时不做强制处理，仍然返回报错信息
                log.error("获取微信请求签名的与微信公众号配置的js认真域名不匹配，场景值：[{}],微信公众号：[{} - {} ]，请求域名：[{}]，配置的安全域名:[{}]",
                        param.getScene(),
                        wechatMpAccount.getAlias(),
                        wechatMpAccount.getAppId(),
                        param.getUrl(),
                        Arrays.toString(jsDomainUrls));
            }

            log.debug("根据[{}]获取js签名信息，使用的公众号ID为：{}", param.getScene());

            return wxMpService.createJsapiSignature(param.getUrl());
        } catch (WxErrorException e) {
            log.error("获取签名失败：" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public WxMpUser exchangeWxMapUser(String scene, String authCode) {
        WxMpService wxMpService = context.obtain(scene);

        if (wxMpService == null) {
            return null;
        }

        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = null;
        try {
            wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(authCode);
            WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);

            log.debug("获取微信信息成功，scene：{},authCode:{},wechatNickName:{},appId:{}",
                    scene,
                    authCode,
                    wxMpUser.getNickname(),
                    wxMpService.getWxMpConfigStorage().getAppId());

            return wxMpUser;
        } catch (WxErrorException e) {
            log.error("根据code获取微信信息失败,场景：[{}],授权码为:[{}],对应的APPID为：[{}]",
                    scene,
                    authCode,
                    wxMpService.getWxMpConfigStorage().getAppId());
            log.error(e.getMessage(), e);
            return null;
        }
    }
}


















