package com.bxm.newidea.component.schedule;

import com.bxm.newidea.component.schedule.task.ScheduleTask;

/**
 * 调度任务推送服务，可手动创建调度任务进行推送，也会检测spring上下文中是否存在定时任务进行推送
 */
public interface ScheduleService {

    /**
     * 推送一个任务到调度中心
     * @param task 任务信息，任务可以通过对应的任务构建器创建
     *             {@link com.bxm.newidea.component.schedule.builder.CronTaskBuilder}
     *             {@link com.bxm.newidea.component.schedule.builder.OnceTaskBuilder}
     * @return true表示任务创建成功
     */
    boolean push(ScheduleTask task);

    /**
     * 删除一个任务
     * @param taskName 任务名
     * @return true表示任务删除成功
     */
    boolean remove(String taskName);

    /**
     * 获取当前执行器的版本
     * 指定执行器的版本，用于实现灰度发布，项目版本升级后，同步升级执行器，用于区分相同服务
     * @return 执行器版本
     */
    String getExecutorVersion();
}
