package com.bxm.newidea.component.schedule.job;

import com.bxm.newidea.component.schedule.enums.ExecutorRouteStrategyEnum;
import com.bxm.newidea.component.schedule.enums.MisfireStrategyEnum;
import com.bxm.newidea.component.schedule.enums.ScheduleTypeEnum;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;

/**
 * 定义一个接口来描述任务的相关配置，子类可以根据情况选择性的覆盖
 * 一般用默认的行为即可，但是也有特殊定制化的情况
 * 同时通过接口的形式，强制性的要求实现则必须提供值
 *
 * @author liujia
 * @date 11/6/21 11:17 PM
 **/
public interface IXxlJobHandlerDefinition {
    /**
     * @return 任务描述，说明任务做的业务
     */
    String jobDesc();

    /**
     * 定时任务的开发者
     *
     * @return 开发者
     */
    String author();

    /**
     * 报警邮件
     */
    default String alarmEmail() {
        return null;
    }

    /**
     * 调度类型
     * 可选值：CRON、NONE、FIX_RATE
     */
    default ScheduleTypeEnum scheduleType() {
        return ScheduleTypeEnum.CRON;
    }

    /**
     * 调度配置，根据调度类型进行具体的配置
     *
     * @return 配置数据
     */
    default String scheduleConf() {
        return null;
    }

    /**
     * 调度过期策略
     * 默认为立即触发一次
     */
    default MisfireStrategyEnum misfireStrategy() {
        return MisfireStrategyEnum.FIRE_ONCE_NOW;
    }

    /**
     * 执行器路由策略
     * 默认为失效转移
     */
    default ExecutorRouteStrategyEnum executorRouteStrategy() {
        return ExecutorRouteStrategyEnum.FAILOVER;
    }

    /**
     * 执行器的名字
     * 默认为类名，不可随意更改
     */
    default String executorHandler() {
        return this.getClass().getSimpleName();
    }

    /**
     * 任务默认的执行参数
     */
    default String executorParam() {
        return null;
    }

    /**
     * 阻塞处理策略
     * 默认单机串行
     */
    default ExecutorBlockStrategyEnum executorBlockStrategy() {
        return ExecutorBlockStrategyEnum.SERIAL_EXECUTION;
    }

    /**
     * 任务执行的超时时间（单位：秒）
     * 默认为-1，表示不进行限制
     */
    default int executorTimeout() {
        return -1;
    }

    /**
     * 失败重试次数
     */
    default int executorFailRetryCount() {
        return 3;
    }
}
