/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.zk.service.impl;

import cn.hutool.core.date.SystemClock;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.zk.exception.ZookeeperException;
import com.bxm.newidea.component.zk.listener.NodeChangeListener;
import com.bxm.newidea.component.zk.listener.NodeChangeWithChildrenListener;
import com.bxm.newidea.component.zk.service.ZookeeperAdapter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ZookeeperAdapterImpl
implements ZookeeperAdapter {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperAdapterImpl.class);
    private CuratorFramework curatorFramework;
    private ThreadLocal<CuratorFramework> curatorFrameworkThreadLocal;
    private static final String JOIN_CHAR = "/";

    public ZookeeperAdapterImpl(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    @Override
    public void changeCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFrameworkThreadLocal = new ThreadLocal();
        this.curatorFrameworkThreadLocal.set(curatorFramework);
    }

    @Override
    public String createNode(String fullPath) {
        return this.createNode(fullPath, CreateMode.PERSISTENT, null);
    }

    @Override
    public <T> String createNode(String fullPath, T data) {
        return this.createNode(fullPath, CreateMode.PERSISTENT, data);
    }

    @Override
    public String createNode(String fullPath, CreateMode createMode) {
        return this.createNode(fullPath, createMode, null);
    }

    @Override
    public <T> String createNode(String fullPath, CreateMode createMode, T data) {
        this.checkPath(fullPath);
        String nodePath = null;
        try {
            nodePath = (String)((ACLBackgroundPathAndBytesable)this.getCuratorFramework().create().creatingParentsIfNeeded().withMode(createMode)).forPath(fullPath, this.toData(data));
        }
        catch (Exception e) {
            this.warpException(e);
        }
        return nodePath;
    }

    @Override
    public void removeNode(String fullPath) {
        this.checkPath(fullPath);
        if (log.isDebugEnabled()) {
            log.debug("\u5220\u9664\u8282\u70b9\uff1a[{}]", (Object)fullPath);
        }
        try {
            fullPath = this.deleteJoinChar(fullPath);
            this.getCuratorFramework().delete().forPath(fullPath);
        }
        catch (Exception e) {
            this.warpException(e);
        }
    }

    @Override
    public void removeNodeWithChildren(String fullPath) {
        this.checkPath(fullPath);
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u540c\u65f6\u5220\u9664[{}]\u4e0b\u7684\u5b50\u8282\u70b9\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u4e1a\u52a1\u9700\u8981\u5982\u6b64", (Object)fullPath);
            }
            fullPath = this.deleteJoinChar(fullPath);
            this.getCuratorFramework().delete().deletingChildrenIfNeeded().forPath(fullPath);
        }
        catch (Exception e) {
            this.warpException(e);
        }
    }

    private String deleteJoinChar(String fullPath) {
        if (StringUtils.endsWithIgnoreCase((String)fullPath, (String)JOIN_CHAR)) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        return fullPath;
    }

    @Override
    public <T> Stat setData(String fullPath, T data) {
        this.checkPath(fullPath);
        Stat stat = null;
        try {
            stat = (Stat)this.getCuratorFramework().setData().forPath(fullPath, this.toData(data));
        }
        catch (Exception e) {
            this.warpException(e);
        }
        return stat;
    }

    @Override
    public <T> Stat setData(String fullPath, T data, int version) {
        this.checkPath(fullPath);
        Stat stat = null;
        try {
            stat = (Stat)((BackgroundPathAndBytesable)this.getCuratorFramework().setData().withVersion(version)).forPath(fullPath, this.toData(data));
        }
        catch (Exception e) {
            if (e instanceof KeeperException.BadVersionException) {
                log.info("\u9519\u8bef\u7684\u7248\u672c\u53f7\uff0cpath:[{}],version:[{}]", (Object)fullPath, (Object)version);
                return null;
            }
            this.warpException(e);
        }
        return stat;
    }

    @Override
    public List<String> obtainChildren(String fullPath, boolean fillFullPath) {
        this.checkPath(fullPath);
        List<Object> subPathList = Lists.newArrayList();
        try {
            String finalParentPath = this.deleteJoinChar(fullPath);
            subPathList = (List)this.getCuratorFramework().getChildren().forPath(finalParentPath);
            if (fillFullPath) {
                subPathList = subPathList.stream().map(subPath -> {
                    if (finalParentPath.endsWith(JOIN_CHAR)) {
                        return finalParentPath + subPath;
                    }
                    return finalParentPath + JOIN_CHAR + subPath;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            this.warpException(e);
        }
        return subPathList;
    }

    @Override
    public <T> T obtainData(String fullPath, Class<T> dataClass) {
        this.checkPath(fullPath);
        T result = null;
        try {
            if (null == dataClass) {
                log.error("\u8c03\u7528\u4e86[obtainData]\u4f46\u662f\u672a\u63d0\u4f9bdataClass\u53c2\u6570\uff0c\u76f4\u63a5\u8fd4\u56denull");
                return null;
            }
            byte[] sourceData = (byte[])this.getCuratorFramework().getData().forPath(fullPath);
            result = this.restoreData(sourceData, dataClass);
        }
        catch (Exception e) {
            this.warpException(e);
        }
        return result;
    }

    @Override
    public Stat obtainStat(String fullPath) {
        this.checkPath(fullPath);
        Stat stat = null;
        try {
            stat = (Stat)this.getCuratorFramework().checkExists().forPath(fullPath);
        }
        catch (Exception e) {
            this.warpException(e);
        }
        return stat;
    }

    @Override
    public boolean checkExists(String fullPath) {
        return this.obtainStat(fullPath) != null;
    }

    @Override
    public void addListener(String fullPath, NodeChangeListener listener) {
        this.checkPath(fullPath);
        Preconditions.checkArgument((null != listener ? 1 : 0) != 0);
        log.info("\u6dfb\u52a0[{}]\u76d1\u542c\u5668", (Object)fullPath);
        String finalFullPath = this.deleteJoinChar(fullPath);
        try {
            NodeCache nodeCache = new NodeCache(this.getCuratorFramework(), finalFullPath, false);
            nodeCache.getListenable().addListener(() -> {
                ChildData currentData = nodeCache.getCurrentData();
                if (null == currentData) {
                    log.info("[{}]\u76d1\u542c\u4e8b\u4ef6\u56de\u8c03\u503c\u4e3a\u7a7a", (Object)fullPath);
                    return;
                }
                listener.updated(fullPath, this.restoreData(currentData.getData()), currentData.getStat());
            });
            nodeCache.start();
        }
        catch (Exception e) {
            this.warpException(e);
        }
    }

    @Override
    public void addListener(String fullPath, NodeChangeWithChildrenListener listener, boolean self) {
        this.checkPath(fullPath);
        Preconditions.checkArgument((null != listener ? 1 : 0) != 0);
        log.info("\u6dfb\u52a0[{}]\u5b50\u8282\u70b9\u76d1\u542c\u5668\uff0c\u662f\u5426\u76d1\u542c\u81ea\u8eab:[{}]", (Object)fullPath, (Object)self);
        try {
            if (self) {
                this.addTreeNodeCache(fullPath, listener);
            } else {
                this.addPathChildrenCache(fullPath, listener);
            }
        }
        catch (Exception e) {
            this.warpException(e);
        }
    }

    private void addPathChildrenCache(String path, NodeChangeWithChildrenListener listener) throws Exception {
        PathChildrenCache pathChildrenCache = new PathChildrenCache(this.getCuratorFramework(), path, false);
        pathChildrenCache.getListenable().addListener((client, event) -> {
            ChildData childData = event.getData();
            if (null == childData) {
                log.info("[{}]\u76d1\u542c\u4e8b\u4ef6\u56de\u8c03\u503c\u4e3a\u7a7a", (Object)path);
                return;
            }
            String data = this.restoreData(childData.getData());
            PathChildrenCacheEvent.Type type = event.getType();
            switch (type) {
                case CONNECTION_RECONNECTED: {
                    pathChildrenCache.rebuild();
                    break;
                }
                case CHILD_ADDED: {
                    listener.added(childData.getPath(), data, childData.getStat());
                    break;
                }
                case CHILD_REMOVED: {
                    listener.removed(childData.getPath(), data, childData.getStat());
                    break;
                }
                case CHILD_UPDATED: {
                    listener.updated(childData.getPath(), data, childData.getStat());
                    break;
                }
            }
        });
        pathChildrenCache.start();
    }

    private void addTreeNodeCache(String path, NodeChangeWithChildrenListener listener) throws Exception {
        TreeCache treeCache = new TreeCache(this.getCuratorFramework(), path);
        treeCache.getListenable().addListener((client, event) -> {
            ChildData childData = event.getData();
            if (null == childData) {
                log.info("[{}]\u76d1\u542c\u4e8b\u4ef6\u56de\u8c03\u503c\u4e3a\u7a7a", (Object)path);
                return;
            }
            TreeCacheEvent.Type type = event.getType();
            String data = this.restoreData(childData.getData());
            switch (type) {
                case NODE_ADDED: {
                    listener.added(childData.getPath(), data, childData.getStat());
                    break;
                }
                case NODE_REMOVED: {
                    listener.removed(childData.getPath(), data, childData.getStat());
                    break;
                }
                case NODE_UPDATED: {
                    listener.updated(childData.getPath(), data, childData.getStat());
                    break;
                }
            }
        });
        treeCache.start();
    }

    private void warpException(Throwable throwable) throws ZookeeperException {
        log.error(throwable.getMessage(), throwable);
        throw new ZookeeperException(throwable);
    }

    private void checkPath(String path) {
        if (StringUtils.isEmpty((Object)path)) {
            throw new ZookeeperException("path\u5fc5\u987b\u63d0\u4f9b");
        }
    }

    private <T> byte[] toData(T source) {
        if (null == source) {
            return this.getDefaultData();
        }
        if (byte[].class.equals(source.getClass())) {
            return (byte[])source;
        }
        String jsonString = JSON.toJSONString(source);
        if (null == jsonString) {
            return source.toString().getBytes();
        }
        return jsonString.getBytes();
    }

    private String restoreData(byte[] source) {
        if (null == source) {
            return null;
        }
        return new String(source);
    }

    private <T> T restoreData(byte[] source, Class<T> dataClass) {
        String sourceString = new String(source);
        return (T)JSON.parseObject((String)sourceString, dataClass);
    }

    private byte[] getDefaultData() {
        return (SystemClock.now() + "").getBytes();
    }

    private CuratorFramework getCuratorFramework() {
        CuratorFramework localFramework;
        if (null != this.curatorFrameworkThreadLocal && null != (localFramework = this.curatorFrameworkThreadLocal.get())) {
            if (log.isDebugEnabled()) {
                log.debug("\u4f7f\u7528\u8bbe\u7f6e\u7684CuratorFramework\uff1a" + localFramework.toString());
            }
            return localFramework;
        }
        return this.curatorFramework;
    }

    @Override
    public void releaseCuratorFramework() {
        if (null != this.curatorFrameworkThreadLocal) {
            if (log.isDebugEnabled()) {
                log.debug("\u91ca\u653eCuratorFramework");
            }
            this.curatorFrameworkThreadLocal.remove();
        }
    }
}

