/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.zk.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperDistributedLock.class);
    private CuratorFramework curatorFramework;
    private ThreadLocal<Map<String, InterProcessMutex>> lockThreadLocal = new ThreadLocal();

    public ZookeeperDistributedLock(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public boolean lock(String resource) {
        return this.lock(resource, 100L, TimeUnit.MILLISECONDS);
    }

    public boolean lock(String resource, long time, TimeUnit timeUnit) {
        boolean result = false;
        try {
            InterProcessMutex lock = this.getLock(resource);
            result = lock.acquire(time, timeUnit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7ed9[{}]\u52a0\u9501\uff0c\u52a0\u9501\u7ed3\u679c\uff1a[{}]\uff0c\u9501\u5b9a\u65f6\u95f4\uff1a[{}][{}]", new Object[]{resource, result, timeUnit.name(), time});
        }
        return result;
    }

    public void unlock(String resource) {
        Map<String, InterProcessMutex> map;
        if (log.isDebugEnabled()) {
            log.debug("[{}]\u89e3\u9501", (Object)resource);
        }
        if (null != (map = this.lockThreadLocal.get())) {
            InterProcessMutex lock = map.get(resource);
            try {
                if (null != lock) {
                    if (lock.isOwnedByCurrentThread()) {
                        lock.release();
                        map.remove(resource);
                    } else {
                        log.info("\u89e3\u9501\u5931\u8d25\uff1a{}", (Object)lock);
                    }
                }
                if (map.size() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u6e05\u7a7athreadLocal");
                    }
                    this.lockThreadLocal.remove();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InterProcessMutex getLock(String resource) {
        Map<String, InterProcessMutex> map = this.lockThreadLocal.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, InterProcessMutex>(5);
            this.lockThreadLocal.set(map);
        }
        String lockNodeParent = "/component/lock/";
        String lockNode = lockNodeParent + resource;
        InterProcessMutex lock = map.get(resource);
        if (null == lock) {
            lock = new InterProcessMutex(this.curatorFramework, lockNode);
            map.put(resource, lock);
        }
        log.info("map size:{}", (Object)map.size());
        return lock;
    }
}

