package com.bxm.localnews.news.util;

import com.bxm.localnews.news.model.vo.MyReplysVO;
import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.param.BasicParam;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author gonzo
 * @date 2021-03-12 11:35
 **/
public class ReplyUtils {

    public static final String STR = "【更新版本后可查看图片】";

    /**
     * 处理评论内容
     *
     * @param replyDTO 评论实体
     */
    public static void processReplyContent(NewsReplyBaseVO replyDTO, boolean isOutWeb) {

        if (isOutWeb) {
            // 站外是只要有a标签就行 刚好如果有@的话就是a标签 这里直接set就行
            // 需要判断一下是否有值 老的评论数据是没有的 需要兼容一下
            if (isNotBlank(replyDTO.getReplyContentHtml())) {
                replyDTO.setReplyContent(replyDTO.getReplyContentHtml());
            }
        } else {
            // 新版本直接返回数据 将带html数据的内容进行返回即可
            // 需要判断一下是否有值 老的评论数据是没有的 需要兼容一下
            if (isNotBlank(replyDTO.getReplyContentHtml())) {
                replyDTO.setReplyContent(replyDTO.getReplyContentHtml());
            }
        }
    }

    /**
     * 处理评论内容
     *
     * @param replyDTO 评论实体
     */
    public static void processReplyContent(MyReplysVO replyDTO, boolean isOutWeb) {

        if (isOutWeb) {
            // 站外是只要有a标签就行 刚好如果有@的话就是a标签 这里直接set就行
            // 需要判断一下是否有值 老的评论数据是没有的 需要兼容一下
            if (isNotBlank(replyDTO.getReplyContentHtml())) {
                replyDTO.setReplyContent(replyDTO.getReplyContentHtml());
            }
        } else {
            // 新版本直接返回数据 将带html数据的内容进行返回即可
            // 需要判断一下是否有值 老的评论数据是没有的 需要兼容一下
            if (isNotBlank(replyDTO.getReplyContentHtml())) {
                replyDTO.setReplyContent(replyDTO.getReplyContentHtml());
            }
        }
    }


    /**
     * 处理评论内容
     *
     * @param replyDTO   评论实体
     * @param basicParam 请求参数
     */
    public static void processReplyContent(NewsReplyBaseVO replyDTO, BasicParam basicParam) {
        boolean isOutWeb = basicParam.getPlatform() == 3;

        processReplyContent(replyDTO, isOutWeb);
    }

}
