package com.bxm.localnews.news.model.dto;

import com.bxm.localnews.news.model.vo.AdminNewsReply;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel("评论列表实体")
@Data
public class AdminReplyDTOAdmin extends AdminNewsReply {

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("纯文本内容")
    private String textField;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("地区信息")
    private String areaDetail;

    @ApiModelProperty("帖子详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("【3.12.0】评论图片")
    private String replyImg;

    @ApiModelProperty("【3.12.0】评论状态 0: 待展示; 1: 已展示（审核通过）; 2: 待审核; 3: 审核拒绝; 4: 仅自己可见;" +
            " 105: 用户删除（伪造的状态）; 106: 运营删除（伪造的状态）")
    private Byte commentStatus;
}
