package com.bxm.localnews.news.model.dto;

import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "新闻评论实体")
@Data
@Builder
public class NewsReplyDTO extends NewsReplyBaseVO {

    private static final long serialVersionUID = 1262373995918185843L;

    @Tolerate
    public NewsReplyDTO() {
        this.isLike = 0;
        this.list = Lists.newArrayList();
        this.deleteFlag = 0;
    }

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("帖子id")
    private Long newsId;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty(hidden = true)
    private Long addTimestamp;

    @ApiModelProperty("是否点赞 1：已点赞 0：未点赞")
    @Builder.Default
    private Integer isLike = 0;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型 1:新闻 2:小视频 3:帖子")
    private Byte type;

    @ApiModelProperty("评论时间")
    private String replyTime;

    @ApiModelProperty("该评论下的回复")
    @Builder.Default
    List<NewsReplyMirrorDTO> list = Lists.newArrayList();

    @ApiModelProperty(value = "删除标记 0：未删除  1：已删除。已删除的评论要显示为已删除状态")
    @Builder.Default
    private Byte deleteFlag = 0;


}
