package com.bxm.localnews.news.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.localnews.news.model.dto.medal.SimpleMedalDTO;
import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "新闻评论详细信息")
@Data
public class NewsReplyDetailDTO extends NewsReplyBaseVO {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    @JSONField(format = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty(hidden = true)
    private Long addTimestamp;

    @ApiModelProperty("是否点赞 1：已点赞 0：未点赞")
    private Integer isLike = 0;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("该评论下的回复")
    List<NewsReplyMirrorDTO> list = new ArrayList<>(10);

    @ApiModelProperty("新闻链接")
    private String linkUrl;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("类型：1.新闻  2.小视频")
    private Byte type;

    @ApiModelProperty("删除标记 0：未删除  1：已删除")
    private byte deleteFlag = 0;

    @ApiModelProperty("评论时间")
    private String replyTime;

    @ApiModelProperty("小视频回复详细实体")
    private ReplyVideoDTO replyVideoDto;

    @ApiModelProperty("新闻回复详细实体")
    private ReplyNewsDTO replyNewsDto;

    @ApiModelProperty("帖子回复详细实体")
    private ReplyPostDTO replyPostDto;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserWarmLevelDTO userWarmLevelDTO;

    @ApiModelProperty(value = "3.12.0 佩戴勋章列表")
    private List<SimpleMedalDTO> wearMedalList;

}
