package com.bxm.localnews.news.model.dto;

import com.bxm.localnews.news.vo.PostImgVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "帖子评论实体")
public class ReplyPostDTO {

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("帖子状态（1：正常显示，2：审核中，3：已下线，4：已删除）")
    private Byte status;

    @ApiModelProperty("帖子图片数组,包含视频")
    private List<PostImgVo> postImgList;

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<PostImgVo> getPostImgList() {
        return postImgList;
    }

    public void setPostImgList(List<PostImgVo> postImgList) {
        this.postImgList = postImgList;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
