package com.bxm.localnews.news.model.entity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author gonzo
 * @date 2020-10-28 14:34
 **/
@Data
public class VirtualReply {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("新闻内容")
    private String textField;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("删除标记 0：未删除  1：已删除")
    private Byte deleteFlag = 0;

    @ApiModelProperty("回复的根id 直接评论新闻则是0，回复新闻下的评论则显示新闻评论id")
    private Long rootId;

    @ApiModelProperty("回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复")
    private Byte level;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型：1.新闻  2.小视频  3.社区")
    private Byte type;

    @ApiModelProperty("互动值")
    private Integer interactiveCount;

    @ApiModelProperty("评论上级id，0为第一级,即新闻下的直接评论")
    private Long parentId;

    @ApiModelProperty("被评论用户id")
    private Long parentUserId;

    @ApiModelProperty("被评论用户昵称")
    private String parentUserNickname;

    @ApiModelProperty("被评论用户头像地址")
    private String parentHeadImg;

    @ApiModelProperty(value = "评论内容", required = true)
    private String replyContent;

    @ApiModelProperty(value = "评论人用户id", required = true)
    private Long userId;

    @ApiModelProperty("评论人昵称")
    private String userNickname;

    @ApiModelProperty("评论人头像地址")
    private String headImg;

    @ApiModelProperty("马甲号互动,0未互动,1已互动")
    private Byte vestInteract;

    @ApiModelProperty("发帖用户昵称")
    private String postUserNickName;

    @ApiModelProperty("发帖用户id")
    private Long postUserId;
}
