package com.bxm.localnews.news.model.param;

import com.bxm.egg.common.vo.INewsIdSharding;
import com.bxm.newidea.component.vo.PageParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhaoyadong 2018/11/9 11:26
 * @desc
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "获取用户评论时时传入的参数")
public class NewsReplyParam extends PageParam implements INewsIdSharding {

    @ApiModelProperty("新闻id | 小视频id | 帖子id")
    private Long newsId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("排序规则 0,按最热  1.按最新")
    private Byte sortRule;

    @ApiModelProperty("地区码")
    private String areaCode;

    @JsonIgnore
    private List<Long> replyIds;


    @Override
    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Byte getSortRule() {
        return sortRule;
    }

    public void setSortRule(Byte sortRule) {
        this.sortRule = sortRule;
    }
}
