package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author gonzo
 * @date 2020-10-22 16:37
 **/

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "马甲号评论列表请求参数")
public class VirtualReplyListParam extends PageParam {

    @ApiModelProperty(value = "帖子id")
    private Long newsId;

    @ApiModelProperty(value = "帖子标题")
    private String newsTitle;

    @ApiModelProperty(value = "接受马甲号昵称")
    private String virtualNickName;

    @ApiModelProperty(value = "评论用户昵称")
    private String userNickName;

    @ApiModelProperty(value = "评论用户id")
    private Long userId;

    @ApiModelProperty(value = "是否回复 null: 全部 0: 未回复 1: 已回复", example = "0")
    private Integer replyStatus;

    @ApiModelProperty(value = "查询的开始时间 默认从当前时间往前挪一个星期开始查询")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date startTime;

    @ApiModelProperty(value = "查询的结束时间 默认当前时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date endTime;

    @ApiModelProperty(value = "马甲号投放的区域编码")
    private String areaCode;
}
