package com.bxm.localnews.news.model.vo;

import com.bxm.egg.common.vo.INewsIdSharding;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "新闻回复持久层实体")
@Data
public class NewsReply extends NewsReplyBaseVO implements INewsIdSharding {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻id | 小视频id | 帖子id")
    private Long newsId;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("删除标记 0：未删除  1：已删除  2:评论下有回复不删除")
    private byte deleteFlag = 0;

    @ApiModelProperty("回复的根id 直接评论新闻则是0，回复新闻下的评论则显示新闻评论id")
    private Long rootId;

    @ApiModelProperty("回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复")
    private Byte level;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型：1.新闻  2.小视频, 3社区帖子")
    private Byte type;

    @ApiModelProperty("状态")
    private Byte status;

    @ApiModelProperty("互动值")
    private Integer interactiveCount;

    @ApiModelProperty("评论时间")
    private String replyTime;

    @ApiModelProperty("是否用户删除")
    private Byte isUserDelete;

    @ApiModelProperty("马甲号互动, 0未互动,1已互动")
    private Byte vestInteract;

    @ApiModelProperty("是否vip 0 :否 1：是")
    private Integer isVip;
}

