package com.bxm.localnews.news.model.vo;

import com.bxm.newidea.component.param.BasicParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "新闻回复基础实体")
@Data
public class NewsReplyBaseVO extends BasicParam {

    private static final long serialVersionUID = -5105176973746655022L;

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("根评论id")
    private Long rootId;

    @ApiModelProperty(value = "回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复", hidden = true)
    private Byte level;

    @ApiModelProperty("评论上级id，0为第一级,即新闻下的直接评论")
    private Long parentId;

    @ApiModelProperty("被评论用户id")
    private Long parentUserId;

    @ApiModelProperty(value = "被评论用户昵称", hidden = true)
    private String parentUserNickname;

    @ApiModelProperty(value = "被评论用户头像地址", hidden = true)
    private String parentHeadImg;

    @ApiModelProperty(value = "【3.12.0变更】评论内容" +
            "支持@用户，格式定义为:  &lt;a wst-user-href=\\\"用户id\\\"&gt;@用户名 &lt;/a&gt; ")
    private String replyContent;

    @ApiModelProperty("【3.12.0】评论图片")
    private String replyImg;

    @ApiModelProperty(value = "状态 0: 待展示; 1: 已展示（审核通过）; 2: 待审核; 3: 审核拒绝; 4: 仅自己可见", hidden = true)
    private Byte status;

    @ApiModelProperty(value = "【3.12.0】评论带html内容 该字段不返回给客户端", hidden = true)
    @JsonIgnore
    private String replyContentHtml;

    @ApiModelProperty(value = "评论人用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "是否是vip：0-不是 1-是", hidden = true)
    private Integer isVip;

    @ApiModelProperty(value = "评论人昵称", hidden = true)
    private String userNickname;

    @ApiModelProperty(value = "评论人头像地址", hidden = true)
    private String headImg;

    @ApiModelProperty("评论人是否作者")
    private Boolean userIsAuthor;

    @ApiModelProperty("被评论人是否作者")
    private Boolean parentUserIsAuthor;

    @ApiModelProperty("是否热门评论 0:不是 1：是")
    private Integer hotReply;

    @ApiModelProperty(value = "设置为热门评论的时间", hidden = true)
    private Date hotReplyTime;

    @ApiModelProperty("是否仅用户可见  0：否  1：是")
    private Integer displayOwner;

    @ApiModelProperty(value = "地区码", hidden = true)
    private String areaCode;

    @ApiModelProperty(value = "评论的用户类型 0:普通用户 1:马甲用户 2:真实用户评论马甲号", hidden = true)
    private Integer replyUserType;
}
