package com.bxm.localnews.integration;

import com.bxm.egg.user.dto.auth.UserAuthCodeDTO;
import com.bxm.egg.user.enums.AuthCodeEnum;
import com.bxm.egg.user.facade.service.UserAuthFacadeService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author liujia
 * @date 10/17/21 4:27 PM
 **/
@Service
@Slf4j
public class UserAuthIntegrationService {

    private UserAuthFacadeService userAuthFacadeService;

    public UserAuthIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.userAuthFacadeService = innerServiceIntegrationService.getUserAuthFacadeService();
    }

    public Message hasPostAuth(Long userId) {
        UserAuthCodeDTO userAuth = userAuthFacadeService.getUserAuth(userId);
        if (null == userAuth || userAuth.getCombineAuthCode() == null) {
            return Message.build();
        }

        if (BitOperatorUtil.hasBit(userAuth.getCombineAuthCode(), AuthCodeEnum.FORBID_POST.index)) {
            log.info("{}尝试发帖，因无权被拒绝", userAuth);
            return Message.build(false, "您已被禁止发帖，详情请咨询客服人员");
        }

        return Message.build();
    }

    public Message hasCommentAuth(Long userId) {
        UserAuthCodeDTO userAuth = userAuthFacadeService.getUserAuth(userId);
        if (null == userAuth || userAuth.getCombineAuthCode() == null) {
            return Message.build();
        }

        if (BitOperatorUtil.hasBit(userAuth.getCombineAuthCode(), AuthCodeEnum.FORBID_COMMENT.index)) {
            log.info("{}尝试评论，因无权被拒绝", userAuth);
            return Message.build(false, "您已被禁止评论，详情请咨询客服人员");
        }

        return Message.build();
    }
}
