package com.bxm.localnews.integration;

import com.bxm.egg.user.enums.OperateTypeEnum;
import com.bxm.egg.user.enums.UserStatisticsTypeEnum;
import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.egg.user.facade.service.UserStatisticsFacadeService;
import com.bxm.localnews.converter.IntegrationConverter;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.sync.core.SyncCacheAgent;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

import static com.bxm.localnews.news.constant.MemoryCacheKey.USER_LOCAL_CACHE;

@Slf4j
@Service
public class UserIntegrationService {

    private final UserInfoFacadeService userInfoFacadeService;

    private UserStatisticsFacadeService userStatisticsFacadeService;

    public UserIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        userInfoFacadeService = innerServiceIntegrationService.getUserInfoFacadeService();
        userStatisticsFacadeService = innerServiceIntegrationService.getUserStatisticsFacadeService();
    }

    private UserBean loadUser(Long userId) {
        UserInfoBO userInfoBO = userInfoFacadeService.selectUserFromCache(userId);

        return IntegrationConverter.INSTANCE.of(userInfoBO);
    }

    public UserBean selectUserFromCache(Long userId) {
        if (null != userId) {
            SyncCacheAgent<Long, UserBean> cacheAgent = SyncCacheHolderFactory.build(USER_LOCAL_CACHE, this::loadUser);
            return cacheAgent.get(userId);
        }

        UserBean user = new UserBean();
        user.setId(userId);
        return user;
    }

    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        return userInfoFacadeService.getUserStatisticsInfo(userId);
    }

    public List<UserBean> batchUserInfo(List<Long> userIdList) {
        List<UserInfoBO> userInfoBOList = userInfoFacadeService.selectUserListFromCache(userIdList);

        return IntegrationConverter.INSTANCE.of(userInfoBOList);
    }

    public void addUserStatisticsNum(Long userId, Integer type) {
        UserStatisticsOperateParam param = new UserStatisticsOperateParam();
        param.setUserId(userId);
        param.setOperateNum(1);

        if (Objects.equals(type, 2)) {
            // 扣除
            param.setOperateTypeEnum(OperateTypeEnum.REDUCE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.POST_NUM);
        } else if (Objects.equals(type, 1)) {
            // 增加帖子数
            param.setOperateTypeEnum(OperateTypeEnum.INCREASE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.POST_NUM);
        } else if (Objects.equals(type, 3)) {
            // 增加评论
            param.setOperateTypeEnum(OperateTypeEnum.INCREASE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.REPLY_NUM);
        } else if (Objects.equals(type, 4)) {
            // 扣除评论
            param.setOperateTypeEnum(OperateTypeEnum.REDUCE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.REPLY_NUM);
        }
        userStatisticsFacadeService.operateUserStatistics(param);
    }

    @Async
    public void updateUserLikeNumByUserId(Long userId) {
        UserStatisticsOperateParam param = new UserStatisticsOperateParam();
        param.setUserId(userId);
        param.setOperateNum(1);
        param.setOperateTypeEnum(OperateTypeEnum.INCREASE);
        param.setUserStatisticsType(UserStatisticsTypeEnum.LIKE_NUM);

        userStatisticsFacadeService.operateUserStatistics(param);
    }

    /**
     * 获取用户的注册信息 注册时间、首次登录时间等等
     *
     * @param userId userId
     * @return 用户的注册信息
     */
    public UserRegisterInfoDTO userRegisterInfo(Long userId) {
        //TODO
        return null;
    }
}
