package com.bxm.localnews.integration;

import com.bxm.foundation.base.facade.service.ShortUrlFacadeService;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/4/9 21:03
 * @desc
 */
@Service
public class ShortLinkIntegrationService {

    private ShortUrlFacadeService shortUrlFacadeService;

    public ShortLinkIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        shortUrlFacadeService = innerServiceIntegrationService.getShortUrlFacadeService();
    }

    /**
     * 用场链接生成短连接
     *
     * @param url ： 场链接
     * @return ： 短连接邀请好了
     */
    public String generateShortUrl(String url) {
        return shortUrlFacadeService.generator(url);
    }

}
