package com.bxm.localnews.integration;

import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.facade.service.UserWarmFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2021/3/5 16:28
 **/
@Component
@Slf4j
public class UserWarmIntegrationService {

    private UserWarmFacadeService userWarmFacadeService;

    public UserWarmIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.userWarmFacadeService = innerServiceIntegrationService.getUserWarmFacadeService();
    }

    /**
     * 更新用户的温暖值
     *
     * @param param 更新参数
     */
    public void updateWarm(UserWarmActionParam param) {
        userWarmFacadeService.updateWarm(param);
    }

}
