package com.bxm.localnews.param;

import com.bxm.newidea.component.vo.BaseParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "定位一个唯一的投票器的相关参数")
@Data
public class VotePinParam extends BaseParam {

    @ApiModelProperty(value = "当前用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "投票插件ID", required = true)
    private Long voteId;

    @ApiModelProperty(value = "投票插件关联的业务ID，如：新闻、帖子的ID", required = true)
    private Long relationId;
}