/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.config.LocalCrumbsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.facade.service.ForumTopicFacadeService;
import com.bxm.localnews.news.model.vo.LocalCrumbs;
import com.bxm.localnews.news.model.vo.topic.TopicCrumbsExtData;
import com.bxm.localnews.news.model.vo.topic.TopicVo;
import com.bxm.localnews.news.service.LocalCircleService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LocalCircleServiceImpl
implements LocalCircleService {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private ForumTopicFacadeService forumTopicFacadeService;
    @Resource
    private LocalCrumbsProperties localCrumbsProperties;

    @Override
    public LocalCrumbs getLocalCrumbsInfo(String userId, String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return this.getEmptyResult();
        }
        LocalCrumbs topicSquareCrumbs = new LocalCrumbs();
        topicSquareCrumbs.setName(this.localCrumbsProperties.getTopicSquareTitle());
        topicSquareCrumbs.setType(Integer.valueOf(1));
        topicSquareCrumbs.setBackgroundImgUrl(this.localCrumbsProperties.getTopicSquareImgUrl());
        topicSquareCrumbs.setJumpUrl(this.localCrumbsProperties.getTopicSquareJumpUrl());
        KeyGenerator nationalCrumbsTotal = this.getNationalAreaTotal();
        KeyGenerator topicSquareAreaTotal = this.getCrumbsAreaTotalKey(1);
        KeyGenerator topicSquareReadCount = this.getCrumbsReadCount(1, areaCode);
        long postTotal = 0L;
        Long areaPostTotal = (Long)this.redisHashMapAdapter.get(topicSquareAreaTotal, areaCode, Long.class);
        Long nationalPostTotal = (Long)this.redisHashMapAdapter.get(nationalCrumbsTotal, "1", Long.class);
        if (nationalPostTotal != null) {
            postTotal += nationalPostTotal.longValue();
        }
        if (areaPostTotal != null) {
            postTotal += areaPostTotal.longValue();
        }
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.exists(topicSquareReadCount, userId))) {
            this.redisHashMapAdapter.put(topicSquareReadCount, userId, (Object)0);
        }
        Long currentUserReadPostCount = (Long)this.redisHashMapAdapter.get(topicSquareReadCount, userId, Long.class);
        if (postTotal > 0L && postTotal > currentUserReadPostCount) {
            topicSquareCrumbs.setLatestCount(Long.valueOf(postTotal - currentUserReadPostCount));
        }
        TopicVo topicLatest = this.forumTopicFacadeService.getTopicLatest(areaCode);
        TopicCrumbsExtData topicCrumbsExtData = new TopicCrumbsExtData();
        topicSquareCrumbs.setExtData(topicCrumbsExtData);
        topicCrumbsExtData.setLatestTopicId(topicLatest.getId());
        topicCrumbsExtData.setLatestTopicTitle("#" + topicLatest.getTitle() + "#");
        return topicSquareCrumbs;
    }

    private LocalCrumbs getEmptyResult() {
        TopicCrumbsExtData topicCrumbsExtData = new TopicCrumbsExtData();
        topicCrumbsExtData.setLatestTopicId(null);
        topicCrumbsExtData.setLatestTopicTitle("");
        LocalCrumbs topicSquareCrumbs = new LocalCrumbs();
        topicSquareCrumbs.setName(this.localCrumbsProperties.getTopicSquareTitle());
        topicSquareCrumbs.setLatestCount(Long.valueOf(0L));
        topicSquareCrumbs.setType(Integer.valueOf(1));
        topicSquareCrumbs.setJumpUrl(this.localCrumbsProperties.getTopicSquareJumpUrl());
        topicSquareCrumbs.setBackgroundImgUrl(this.localCrumbsProperties.getTopicSquareImgUrl());
        topicSquareCrumbs.setExtData(topicCrumbsExtData);
        return topicSquareCrumbs;
    }

    @Override
    public Boolean reportCrumbsInfo(Long userId, String areaCode, Integer type) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return Boolean.TRUE;
        }
        KeyGenerator crumbsAreaTotal = this.getCrumbsAreaTotalKey(type);
        KeyGenerator crumbsNationalTotal = this.getNationalAreaTotal();
        KeyGenerator crumbsReadCount = this.getCrumbsReadCount(type, areaCode);
        if (type == 1) {
            long postTotal = 0L;
            Long areaPostTotal = (Long)this.redisHashMapAdapter.get(crumbsAreaTotal, areaCode, Long.class);
            Long nationalPostTotal = (Long)this.redisHashMapAdapter.get(crumbsNationalTotal, String.valueOf(type), Long.class);
            if (areaPostTotal != null) {
                postTotal += areaPostTotal.longValue();
            }
            if (nationalPostTotal != null) {
                postTotal += nationalPostTotal.longValue();
            }
            if (postTotal > 0L) {
                this.redisHashMapAdapter.put(crumbsReadCount, String.valueOf(userId), (Object)postTotal);
            }
        }
        return Boolean.TRUE;
    }

    private KeyGenerator getCrumbsAreaTotalKey(int type) {
        return RedisConfig.CRUMBS_AREA_TOTAL.copy().appendKey((Object)type);
    }

    private KeyGenerator getCrumbsReadCount(int type, String areaCode) {
        return RedisConfig.CRUMBS_READ_COUNT.copy().appendKey((Object)type).appendKey((Object)areaCode);
    }

    private KeyGenerator getNationalAreaTotal() {
        return RedisConfig.NATIONAL_AREA_TOTAL.copy();
    }
}

