/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.PlusEntryProperties;
import com.bxm.localnews.news.constant.RedisCacheKey;
import com.bxm.localnews.news.domain.NewsPublishEntryExtendMapper;
import com.bxm.localnews.news.model.dto.IndexPlusDTO;
import com.bxm.localnews.news.model.dto.IndexPlusUserInfoDTO;
import com.bxm.localnews.news.model.dto.LinkDTO;
import com.bxm.localnews.news.model.entity.NewsPublishEntry;
import com.bxm.localnews.news.model.entity.NewsPublishEntryArea;
import com.bxm.localnews.news.model.param.IndexPlusParam;
import com.bxm.localnews.news.service.PublishEntryService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PublishEntryServiceImpl
implements PublishEntryService {
    private static final Logger log = LoggerFactory.getLogger(PublishEntryServiceImpl.class);
    private final NewsPublishEntryExtendMapper newsPublishEntryExtendMapper;
    private final UserIntegrationService userIntegrationService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final PlusEntryProperties plusEntryProperties;

    @Override
    public IndexPlusDTO index(IndexPlusParam param) {
        if (StringUtils.isBlank((CharSequence)param.getAreaCode())) {
            log.warn("\u83b7\u53d6\u53d1\u5e16\u5165\u53e3\u7684\u5feb\u6377\u5165\u53e3\u914d\u7f6e\u5931\u8d25\uff0c\u7f3a\u5c11areaCode, \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param));
            IndexPlusDTO indexPlus = new IndexPlusDTO();
            indexPlus.setPrimary(Collections.emptyList());
            indexPlus.setSecondary(Collections.emptyList());
            return indexPlus;
        }
        IndexPlusDTO indexPlus = (IndexPlusDTO)this.redisHashMapAdapter.get(RedisCacheKey.PUBLISH_ENTRY_KEY, param.getAreaCode(), IndexPlusDTO.class);
        if (Objects.isNull(indexPlus) || indexPlus.getV() == null || indexPlus.getV() < 1) {
            indexPlus = new IndexPlusDTO();
            indexPlus.setPrimary(Collections.emptyList());
            indexPlus.setSecondary(Collections.emptyList());
            List newsPublishEntries = this.newsPublishEntryExtendMapper.selectAllUpEntry();
            if (CollectionUtils.isEmpty((Collection)newsPublishEntries)) {
                return indexPlus;
            }
            Map<Object, Object> areaInfosTemp = Maps.newHashMap();
            List newsPublishEntryAreas = this.newsPublishEntryExtendMapper.listEntryByArea(param.getAreaCode());
            if (!CollectionUtils.isEmpty((Collection)newsPublishEntryAreas)) {
                areaInfosTemp = newsPublishEntryAreas.stream().collect(Collectors.groupingBy(NewsPublishEntryArea::getType, Collectors.groupingBy(NewsPublishEntryArea::getPublishEntryId)));
            }
            HashMap areaInfos = areaInfosTemp;
            Map publishMap = (newsPublishEntries = newsPublishEntries.stream().filter(p -> {
                if (Objects.equals(p.getGlobalStatus(), (byte)1)) {
                    return Objects.isNull(areaInfos.get((byte)1)) || CollectionUtils.isEmpty((Collection)((Collection)((Map)areaInfos.get((byte)1)).get(p.getId())));
                }
                return Objects.nonNull(areaInfos.get((byte)0)) && !CollectionUtils.isEmpty((Collection)((Collection)((Map)areaInfos.get((byte)0)).get(p.getId())));
            }).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(NewsPublishEntry::getLevel, Collectors.mapping(this::convert, Collectors.toList())));
            if (!CollectionUtils.isEmpty((Collection)publishMap.get((byte)1))) {
                indexPlus.setPrimary(publishMap.get((byte)1));
            }
            if (!CollectionUtils.isEmpty((Collection)publishMap.get((byte)2))) {
                indexPlus.setSecondary(publishMap.get((byte)2));
            }
            this.redisHashMapAdapter.put(RedisCacheKey.PUBLISH_ENTRY_KEY, param.getAreaCode(), (Object)indexPlus);
        }
        IndexPlusDTO indexPlusDTO = this.fillGuideInfo(indexPlus, param);
        this.versionFilter(indexPlusDTO, param);
        return indexPlusDTO;
    }

    private void versionFilter(IndexPlusDTO indexPlusDTO, IndexPlusParam param) {
        List primaryList = indexPlusDTO.getPrimary();
        List secondaryList = indexPlusDTO.getSecondary();
        if (CollectionUtils.isNotEmpty((Collection)primaryList)) {
            List resultPrimaryList = primaryList.stream().filter(primaryItem -> StringUtils.isBlank((CharSequence)primaryItem.getVersion()) || Objects.equals("0", primaryItem.getVersion()) || StringUtils.isNotBlank((CharSequence)param.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)param.getCurVer(), (String)primaryItem.getVersion())).collect(Collectors.toList());
            indexPlusDTO.setPrimary(resultPrimaryList);
        }
        if (CollectionUtils.isNotEmpty((Collection)secondaryList)) {
            List resultSecondaryList = secondaryList.stream().filter(secondaryItem -> StringUtils.isBlank((CharSequence)secondaryItem.getVersion()) || Objects.equals("0", secondaryItem.getVersion()) || StringUtils.isNotBlank((CharSequence)param.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)param.getCurVer(), (String)secondaryItem.getVersion())).collect(Collectors.toList());
            indexPlusDTO.setSecondary(resultSecondaryList);
        }
    }

    private IndexPlusDTO fillGuideInfo(IndexPlusDTO indexPlus, IndexPlusParam param) {
        UserRegisterInfoDTO userRegisterInfoDTO = this.userIntegrationService.userRegisterInfo(param.getUserId());
        int day = 0;
        if (Objects.nonNull(userRegisterInfoDTO)) {
            IndexPlusUserInfoDTO userInfoDTO = new IndexPlusUserInfoDTO();
            userInfoDTO.setImgUrl(userRegisterInfoDTO.getHeadImg());
            userInfoDTO.setNickName(userRegisterInfoDTO.getNickname());
            userInfoDTO.setUserId(userRegisterInfoDTO.getUserId());
            if (Objects.nonNull(userRegisterInfoDTO.getIntoAppDays())) {
                day = userRegisterInfoDTO.getIntoAppDays();
            }
            indexPlus.setUserInfo(userInfoDTO);
        }
        indexPlus.setGuideContent(String.format(this.plusEntryProperties.getGuideContent(), day));
        return indexPlus;
    }

    private LinkDTO convert(NewsPublishEntry entry) {
        LinkDTO link = new LinkDTO();
        link.setId(entry.getId());
        link.setTitle(entry.getTitle());
        link.setSubTitle(entry.getSubTitle());
        link.setIcon(entry.getIconUrl());
        link.setProtocolUrl(entry.getProtocol());
        link.setVersion(entry.getVersion());
        return link;
    }

    public PublishEntryServiceImpl(NewsPublishEntryExtendMapper newsPublishEntryExtendMapper, UserIntegrationService userIntegrationService, RedisHashMapAdapter redisHashMapAdapter, PlusEntryProperties plusEntryProperties) {
        this.newsPublishEntryExtendMapper = newsPublishEntryExtendMapper;
        this.userIntegrationService = userIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.plusEntryProperties = plusEntryProperties;
    }
}

