/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import com.bxm.localnews.news.detail.helper.ForumPostImageHelper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.service.ReplyScheduleService;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;

@Service
public class ReplyScheduleServiceImpl
extends BaseService
implements ReplyScheduleService {
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private MessageService messageService;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private ForumPostImageHelper forumPostImageHelper;
    @Resource
    private ImageHelper imageHelper;
    @Resource
    private ForumPostInnerService forumPostInnerService;

    @Override
    public void scanningNewsReply() {
        List newsReplyList = this.newsReplyMapper.selectByTime();
        for (NewsReply newsReply : newsReplyList) {
            try {
                this.newsReplyMapper.updateStatus(newsReply.getNewsId(), newsReply.getId());
                this.userReplyMapper.updateStatus(newsReply.getUserId(), newsReply.getId());
                this.pushAndStatic(newsReply);
                this.logger.info("\u8bc4\u8bba\u6570\u636e:[{}],\u63a8\u9001\u65f6\u95f4:[{}]", (Object)JSON.toJSONString((Object)newsReply), (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (ReplyTypeEnum.POST_REPLY.getCode() != newsReply.getType().byteValue()) continue;
                NewNewsReplyService newNewsReplyService = (NewNewsReplyService)SpringContextHolder.getBean(NewNewsReplyService.class);
                newNewsReplyService.saveForumPostReplyRecord(newsReply.getUserId(), newsReply.getNewsId(), newsReply.getAddTime());
            }
            catch (Exception e2) {
                this.logger.error("\u5e16\u5b50\u8bc4\u8bba\u5904\u7406\u51fa\u9519, newsReply: {}", (Object)JSON.toJSONString((Object)newsReply), (Object)e2);
            }
        }
        Collection<List<NewsReply>> values = newsReplyList.stream().collect(Collectors.groupingBy(NewsReply::getNewsId)).values();
        values.forEach(e -> {
            Optional first = e.stream().findFirst();
            first.ifPresent(newsReply -> ((NewNewsReplyService)SpringContextHolder.getBean(NewNewsReplyService.class)).updateComment((NewsReply)newsReply));
        });
    }

    private void pushAndStatic(NewsReply newsReply) {
        ForumPostVo forumPostVo;
        if (newsReply.getParentId() != 0L && newsReply.getRootId() != 0L) {
            NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            if (Objects.isNull(rootReply)) {
                return;
            }
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = Objects.isNull(interactiveCount) || interactiveCount == 0 ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            if (rootReply.getDeleteFlag() == 0) {
                ForumPostVo forumPostVo2;
                boolean userAvailable;
                UserBean userBean = this.userIntegrationService.selectUserFromCache(newsReply.getParentUserId());
                boolean bl = userAvailable = Objects.nonNull(userBean) && Objects.nonNull(userBean.getState()) && userBean.getState() == 1;
                if (userAvailable && newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode() && null != (forumPostVo2 = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId())) && !forumPostVo2.getStatus().equals(PostStatusEnum.USER_DELETE.getCode())) {
                    try {
                        FormPostContentUtil.replace((ForumPostVo)forumPostVo2, null);
                        forumPostVo2.setPostImgList(this.imageHelper.getDetailFromPost(forumPostVo2.getPostImgList()));
                    }
                    catch (Exception e) {
                        this.logger.error("[\u8bc4\u8bba\u5b9a\u65f6\u626b\u63cf]\u626b\u63cf\u8bc4\u8bba\u8868\u7ec4\u88c5\u63a8\u9001\u6d88\u606f\u65f6\u62a5\u9519:[{}],\u6570\u636e:[{}]", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)forumPostVo2));
                    }
                    this.messageService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY, forumPostVo2);
                }
            } else {
                rootReply.setDeleteFlag((byte)2);
                this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            }
        }
        if (newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode() && newsReply.getRootId() == 0L && Objects.nonNull(forumPostVo = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId())) && !Objects.equals(forumPostVo.getStatus(), PostStatusEnum.USER_DELETE.getCode())) {
            this.forumPostImageHelper.exchangeDetailPost(forumPostVo);
            this.messageService.pushPostReplyMessage(newsReply, forumPostVo);
        }
    }
}

