/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.mq.common.model.dto;

import com.bxm.egg.mq.common.constant.PlatformTypeEnum;
import com.bxm.egg.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class PushReceiveScope
extends BaseBean {
    private Long userId;
    private List<Long> userIds;
    private PushReceiverRuleEnum pushReceiverRule;
    private Map<String, Object> ruleParam;
    private List<PlatformTypeEnum> platformTypes;

    private PushReceiveScope() {
    }

    public static PushReceiveScope pushSignle(Long userId) {
        return new PushReceiveScope().setPushReceiverRule(PushReceiverRuleEnum.DEFAULT).setUserId(userId).addRuleParam("userIds", ImmutableList.of((Object)userId).asList());
    }

    public static PushReceiveScope pushGroup(List<Long> userIds) {
        return new PushReceiveScope().setPushReceiverRule(PushReceiverRuleEnum.DEFAULT).setUserIds(userIds).addRuleParam("userIds", userIds);
    }

    public static PushReceiveScope pushRule(PushReceiverRuleEnum pushReceiverRule) {
        return new PushReceiveScope().setPushReceiverRule(pushReceiverRule);
    }

    public static PushReceiveScope pushAreaCodes(List<String> areaCodeList) {
        return new PushReceiveScope().setPushReceiverRule(PushReceiverRuleEnum.CONDITION).addRuleParam("areaCodes", areaCodeList);
    }

    public List<PlatformTypeEnum> getPlatformTypes() {
        return this.platformTypes;
    }

    public PushReceiveScope setPlatformTypes(List<PlatformTypeEnum> platformTypes) {
        this.platformTypes = platformTypes;
        return this;
    }

    public PushReceiverRuleEnum getPushReceiverRule() {
        return this.pushReceiverRule;
    }

    public PushReceiveScope setPushReceiverRule(PushReceiverRuleEnum pushReceiverRule) {
        this.pushReceiverRule = pushReceiverRule;
        return this;
    }

    public PushReceiveScope addRuleParam(String key, Object value) {
        if (null == this.ruleParam) {
            this.ruleParam = Maps.newHashMap();
        }
        this.ruleParam.put(key, value);
        return this;
    }

    public Map<String, Object> getRuleParam() {
        return this.ruleParam;
    }

    public PushReceiveScope setRuleParam(Map<String, Object> ruleParam) {
        this.ruleParam = ruleParam;
        return this;
    }

    public Long getUserId() {
        return this.userId;
    }

    public PushReceiveScope setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public List<Long> getUserIds() {
        if (this.userIds == null) {
            this.userIds = Lists.newArrayList();
        }
        if (this.userId != null && !this.userIds.contains(this.userId)) {
            this.userIds.add(this.userId);
        }
        return this.userIds;
    }

    public PushReceiveScope setUserIds(List<Long> userIds) {
        this.userIds = userIds;
        return this;
    }
}

