package com.bxm.egg.message.facade.param;

import com.bxm.egg.mq.common.constant.SmsTemplateEnum;
import com.bxm.newidea.component.param.BasicParam;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

/**
 * 短信验证码检查参数
 *
 * @author liujia
 * @date 9/28/21 8:10 PM
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class CheckSmsCodeParam extends BasicParam {

    @Tolerate
    public CheckSmsCodeParam() {
    }

    /**
     * 短信类型
     */
    private SmsTemplateEnum type;

    /**
     * 手机号码
     */
    private String phoneNum;

    /**
     * 验证码
     */
    private String code;

    /**
     * 请求IP
     */
    private String requestIp;
}
