package com.bxm.egg.message.facade.param;

import com.bxm.egg.mq.common.constant.SmsTemplateEnum;
import com.bxm.newidea.component.param.BasicParam;
import com.google.common.collect.Lists;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * 模板短信发送参数
 *
 * @author liujia
 * @date 9/28/21 8:17 PM
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class SmsTemplateSendParam extends BasicParam {

    /**
     * 接受短信的电话号码
     */
    private String phoneNum;

    /**
     * 短信发送模板
     */
    private SmsTemplateEnum template;

    /**
     * 变量列表，替换发送模板中的变量
     */
    @Builder.Default
    private List<String> variableList = Lists.newArrayList();

    /**
     * 请求IP，如果来自客户端，则从请求中获取，用于限制
     */
    private String requestIp;

    @Tolerate
    public SmsTemplateSendParam() {
    }
}
