package com.bxm.egg.message.facade.service;

import com.bxm.newidea.component.bo.Message;

import java.util.Date;

/**
 * 即时通讯相关的facade接口
 *
 * @author liujia
 * @date 10/9/21 4:45 PM
 **/
public interface IMFacadeService {

    /**
     * 屏蔽用户即时通讯状态
     *
     * @param userId  用户ID
     * @param endTime 解除屏蔽时间
     * @return
     */
    Message block(Long userId, Date endTime);

    /**
     * 解除用户屏蔽
     *
     * @param userId 用户ID
     * @return 操作结果
     */
    Message unblock(Long userId);

    /**
     * 同步用户信息
     *
     * @param userId   用户ID
     * @param nickName 用户昵称
     * @param headImg  用户头像
     */
    void syncUserInfo(Long userId, String nickName, String headImg);
}
