package com.bxm.localnews.im.domain;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.localnews.im.dto.chat.ChatMessageDTO;
import com.bxm.localnews.im.dto.group.GroupMessageDTO;
import com.bxm.localnews.im.entity.AllVirtureUserVo;
import com.bxm.localnews.im.param.chat.GroupMessageQueryParam;
import com.bxm.localnews.im.param.chat.ImHistoryParam;
import com.bxm.localnews.im.param.chat.ImMessageQueryParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface IMMapper {
    List<ChatMessageDTO> query(ImMessageQueryParam param);

    /**
     * 分组查询群组消息
     *
     * @param page  分页参数
     * @param param 查询条件
     * @return 分页结果
     */
    IPage<GroupMessageDTO> queryGroupMessage(@Param("page") Page<GroupMessageDTO> page,
                                             @Param("param") GroupMessageQueryParam param);

    String selectContentById(String id);

    List<Long> queryHistory(ImHistoryParam param);

    List<Long> selectReplyRecordByVirUserId(Long virtualUserId);

    /**
     * 查询指定用户的最后的私聊时间
     *
     * @param userIds 要查询的用户id
     * @return 私聊时间集合
     */
    List<AllVirtureUserVo> selectLastTimeByUserIds(@Param("userIds") List<Long> userIds);
}
