package com.bxm.localnews.im.domain;

import com.bxm.localnews.im.vo.UserBlockBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserBlockMapper {

    /**
     * 新增用户屏蔽记录
     *
     * @param entity 屏蔽信息实体
     * @return 新增结果
     */
    int insert(UserBlockBean entity);

    /**
     * 取消用户屏蔽记录
     *
     * @param userId      用户ID
     * @param blockUserId 被屏蔽的用户ID
     * @return 更新结果
     */
    int cancel(@Param("userId") Long userId, @Param("blockUserId") Long blockUserId);

    /**
     * 将运营设置的屏蔽用户进行解除
     *
     * @param userId 屏蔽的用户ID
     * @return 更新结果
     */
    int unblock(Long userId);

    /**
     * 查询已经到底过期时间的未接触的屏蔽信息
     *
     * @param expiredTime 过期时间
     * @return 屏蔽用户列表
     */
    List<UserBlockBean> getExpiredBlockList(Date expiredTime);
}
