package com.bxm.localnews.im.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 定时红包生成的可领取红包详情 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-26
 */
@Mapper
public interface RedpacketPlanDetailMapper extends BaseMapper<RedpacketPlanDetailEntity> {

    /**
     * 查询投放计划对应的激活状态的红包
     *
     * @param planId 投放计划ID
     * @return 最终的红包信息
     */
    RedpacketPlanDetailEntity getActiveRedpacket(Long planId);

    /**
     * 获取群组内最近的红包信息,包括领取结束、待领取的
     *
     * @param groupId     群组ID
     * @param closestTime 最近可显示的红包的判断标准
     * @return 红包信息
     */
    List<RedpacketPlanDetailEntity> getClosestRedpacket(@Param("groupId") Long groupId,
                                                        @Param("beforeTime") Date beforeTime,
                                                        @Param("closestTime") Date closestTime);

    /**
     * 获取可领取时间之内的待领取红包
     *
     * @param receiveDate 可领取时间
     * @return 红包列表
     */
    List<RedpacketPlanDetailEntity> getWaitRedpacket(Date receiveDate);

    /**
     * 获取可领取时间之前的处于领取状态的红包
     *
     * @param receiveDate 领取时间
     * @return 红包列表
     */
    List<RedpacketPlanDetailEntity> getReceiveRedpacket(Date receiveDate);
}
