package com.bxm.localnews.im.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.dto.activity.ImTimingRedPacketPlanDTO;
import com.bxm.localnews.im.entity.activity.RedpacketPlanEntity;
import com.bxm.localnews.im.param.activity.ChangeRedPackageStatusParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 定时红包投放计划 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-26
 */
@Mapper
public interface RedpacketPlanMapper extends BaseMapper<RedpacketPlanEntity> {

    /**
     * 查询群组内未删除的定时计划
     *
     * @param groupId 群组ID
     * @return 红包发放计划ID
     */
    List<ImTimingRedPacketPlanDTO> getPlanListByGroupId(Long groupId);

    /**
     * 移除投放计划
     *
     * @param planId 投放计划ID
     * @return 影响行数
     */
    int remove(Long planId);

    /**
     * 变更红包投放计划状态
     *
     * @param param 变更操作参数
     * @return 影响行数
     */
    int changeStatus(ChangeRedPackageStatusParam param);

    /**
     * 增加红包投放次数
     *
     * @param updateEntity 更新参数
     * @return 更新结果
     */
    int addTimes(RedpacketPlanEntity updateEntity);

    /**
     * 查询处于激活状态的红包计划
     * 并且对应的群组也需要在启用状态
     *
     * @param minHour 红包发放开始的时间：小时
     * @param maxHour 红包发放结束的时间：小时
     * @param today   今日时间（判断是否已经存在今日的红包）
     * @return 红包投放计划
     */
    List<RedpacketPlanEntity> queryActivePlanByTime(@Param("minHour") int minHour,
                                                    @Param("maxHour") int maxHour,
                                                    @Param("today") Date today);
}
