package com.bxm.localnews.im.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.entity.activity.RedpacketRemindEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 红包领取提醒记录 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-26
 */
@Mapper
public interface RedpacketRemindMapper extends BaseMapper<RedpacketRemindEntity> {

    /**
     * 查询用户是否已经设置了提醒
     *
     * @param userId  设置提醒的用户ID
     * @param groupId 用户设置了提醒的群组
     */
    RedpacketRemindEntity selectByUserId(@Param("userId") Long userId, @Param("groupId") Long groupId);

    /**
     * 删除用户的提醒信息
     *
     * @param userId  用户ID
     * @param groupId 群组ID
     * @return 影响行数
     */
    int deleteByUserId(@Param("userId") Long userId, @Param("groupId") Long groupId);

    /**
     * 查询群组内设置了提醒的用户ID列表
     *
     * @param groupId 群组ID
     * @return 用户ID列表
     */
    List<Long> selectRemindUserByGroupId(Long groupId);
}
