package com.bxm.localnews.im.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.entity.activity.RedpacketRemindMessageEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 红包领取提醒消息 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-26
 */
@Mapper
public interface RedpacketRemindMessageMapper extends BaseMapper<RedpacketRemindMessageEntity> {

    /**
     * 删除红包的相关提醒
     *
     * @param detailId 红包ID
     * @return 影响行数
     */
    int deleteByDetailId(Long detailId);

    /**
     * 查询小于或等于sendTime的提示消息
     *
     * @param sendTime 消息发送事件
     * @return 消息列表
     */
    List<RedpacketRemindMessageEntity> queryRemind(Date sendTime);

    /**
     * 删除所有已发送的提示消息
     *
     * @param sendTime 发送事件
     * @return 删除行数
     */
    int removeSendRemind(Date sendTime);
}
